/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.log.common.DataSource;
import com.aliyun.openservices.log.common.DataSourceType;
import com.aliyun.openservices.log.util.JsonUtils;
import java.lang.reflect.Type;
import java.util.Map;

public class KafKaSource
extends DataSource {
    private String topics;
    private String bootstrapServers;
    private ValueType valueType;
    private KafkaPosition fromPosition;
    private long fromTimestamp;
    private long toTimestamp;
    private String timeField;
    private String timePattern;
    private String timeFormat;
    private String timeZone;
    private Map<String, String> additionalProps;

    public KafKaSource() {
        super(DataSourceType.KAFKA);
    }

    public String getTopics() {
        return this.topics;
    }

    public void setTopics(String topics) {
        this.topics = topics;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public KafkaPosition getFromPosition() {
        return this.fromPosition;
    }

    public void setFromPosition(KafkaPosition fromPosition) {
        this.fromPosition = fromPosition;
    }

    public long getFromTimestamp() {
        return this.fromTimestamp;
    }

    public void setFromTimestamp(long fromTimestamp) {
        this.fromTimestamp = fromTimestamp;
    }

    public long getToTimestamp() {
        return this.toTimestamp;
    }

    public void setToTimestamp(long toTimestamp) {
        this.toTimestamp = toTimestamp;
    }

    public String getTimeField() {
        return this.timeField;
    }

    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    public String getTimePattern() {
        return this.timePattern;
    }

    public void setTimePattern(String timePattern) {
        this.timePattern = timePattern;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Map<String, String> getAdditionalProps() {
        return this.additionalProps;
    }

    public void setAdditionalProps(Map<String, String> additionalProps) {
        this.additionalProps = additionalProps;
    }

    @Override
    public void deserialize(JSONObject jsonObject) {
        super.deserialize(jsonObject);
        this.topics = JsonUtils.readOptionalString(jsonObject, "topics");
        this.bootstrapServers = JsonUtils.readOptionalString(jsonObject, "bootstrapServers");
        this.valueType = ValueType.fromString(jsonObject.getString("valueType"));
        this.fromPosition = KafkaPosition.fromString(jsonObject.getString("fromPosition"));
        this.fromTimestamp = jsonObject.getLongValue("fromTimestamp");
        this.toTimestamp = jsonObject.getLongValue("toTimestamp");
        this.timeField = jsonObject.getString("timeField");
        this.timePattern = jsonObject.getString("timePattern");
        this.timeFormat = jsonObject.getString("timeFormat");
        this.timeZone = jsonObject.getString("timeZone");
        this.additionalProps = JsonUtils.readOptionalMap(jsonObject, "additionalProps");
    }

    public static enum ValueType implements JSONSerializable
    {
        JSON,
        TEXT;


        public static ValueType fromString(String value) {
            for (ValueType type : ValueType.values()) {
                if (!type.name().equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }

        public void write(JSONSerializer jsonSerializer, Object o, Type type, int i) {
            jsonSerializer.write(this.name());
        }
    }

    public static enum KafkaPosition implements JSONSerializable
    {
        GROUP_OFFSETS,
        EARLIEST,
        LATEST,
        TIMESTAMP;


        public static KafkaPosition fromString(String value) {
            for (KafkaPosition position : KafkaPosition.values()) {
                if (!position.name().equalsIgnoreCase(value)) continue;
                return position;
            }
            return null;
        }

        public void write(JSONSerializer jsonSerializer, Object o, Type type, int i) {
            jsonSerializer.write(this.name());
        }
    }
}

