/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.ExecutingRunnable;
import com.alipay.sofa.common.thread.ThreadPoolConfig;
import com.alipay.sofa.common.thread.ThreadPoolGovernor;
import com.alipay.sofa.common.thread.ThreadPoolStatistics;
import com.alipay.sofa.common.thread.log.ThreadLogger;
import com.alipay.sofa.common.tracer.TracerIdAdapter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class ThreadPoolMonitorRunner
implements Runnable {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZoneId.systemDefault());
    private final ThreadPoolConfig config;
    private final ThreadPoolStatistics statistics;

    public ThreadPoolMonitorRunner(ThreadPoolConfig threadPoolConfig, ThreadPoolStatistics threadPoolStatistics) {
        this.statistics = threadPoolStatistics;
        this.config = threadPoolConfig;
    }

    @Override
    public void run() {
        try {
            if (ThreadPoolGovernor.getInstance().isGlobalMonitorLoggable()) {
                int decayedTaskCount = 0;
                for (Map.Entry<ExecutingRunnable, Long> entry : this.statistics.getExecutingTasks().entrySet()) {
                    decayedTaskCount = this.calculateDecayedTaskCounts(decayedTaskCount, entry);
                }
                ThreadLogger.info("Thread pool '{}' info: [{},{},{},{},{}]", this.config.getIdentity(), this.statistics.getQueueSize(), this.statistics.getExecutingTasks().size(), this.statistics.getPoolSize() - (long)this.statistics.getExecutingTasks().size(), this.statistics.getPoolSize(), decayedTaskCount);
                if (this.statistics.getTotalTaskCount() != 0L) {
                    ThreadLogger.info("Thread pool '{}' average static info: [{},{}]", this.config.getIdentity(), this.statistics.getAverageStayInQueueTime(), this.statistics.getAverageRunningTime());
                    this.statistics.resetAverageStatics();
                }
            }
        }
        catch (Throwable e) {
            ThreadLogger.warn("ThreadPool '{}' is interrupted when running: {}", this.config.getIdentity(), e);
        }
    }

    private int calculateDecayedTaskCounts(int decayedTaskCount, Map.Entry<ExecutingRunnable, Long> entry) {
        ExecutingRunnable task = entry.getKey();
        long executionTime = System.currentTimeMillis() - (task.getDequeueTime() == 0L ? entry.getValue().longValue() : task.getDequeueTime());
        if (executionTime >= this.config.getTaskTimeoutMilli()) {
            ++decayedTaskCount;
            this.printStackTrace(task, entry.getKey().getThread());
        }
        return decayedTaskCount;
    }

    private void printStackTrace(ExecutingRunnable task, Thread executingThread) {
        if (!task.isPrinted()) {
            task.setPrinted(true);
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement e : executingThread.getStackTrace()) {
                sb.append("    ").append(e).append("\n");
            }
            String traceId = TracerIdAdapter.getInstance().traceIdSafari(executingThread);
            try {
                ThreadLogger.warn("Task {} in thread pool {} started on {}{} exceeds the limit of {} execution time with stack trace:\n    {}", task, this.config.getIdentity(), DATE_FORMAT.format(Instant.ofEpochMilli(task.getDequeueTime())), traceId == null ? "" : " with traceId " + traceId, this.config.getTaskTimeout() + this.config.getTimeUnit().toString(), sb.toString().trim());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

