/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.eagleeye;

import com.alibaba.csp.sentinel.eagleeye.StatEntry;
import com.alibaba.csp.sentinel.eagleeye.StatEntryFunc;
import com.alibaba.csp.sentinel.eagleeye.StatEntryFuncFactory;
import com.alibaba.csp.sentinel.eagleeye.StatLogController;
import com.alibaba.csp.sentinel.eagleeye.StatLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class StatRollingData {
    private final StatLogger statLogger;
    private final long timeSlot;
    private final long rollingTimeMillis;
    private final ReentrantLock writeLock;
    private final Map<StatEntry, StatEntryFunc> statMap;

    StatRollingData(StatLogger statLogger, int initialCapacity, long timeSlot, long rollingTimeMillis) {
        this(statLogger, timeSlot, rollingTimeMillis, new ConcurrentHashMap<StatEntry, StatEntryFunc>(Math.min(initialCapacity, statLogger.getMaxEntryCount())));
    }

    private StatRollingData(StatLogger statLogger, long timeSlot, long rollingTimeMillis, Map<StatEntry, StatEntryFunc> statMap) {
        this.statLogger = statLogger;
        this.timeSlot = timeSlot;
        this.rollingTimeMillis = rollingTimeMillis;
        this.writeLock = new ReentrantLock();
        this.statMap = statMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatEntryFunc getStatEntryFunc(StatEntry statEntry, StatEntryFuncFactory factory) {
        StatEntryFunc func = this.statMap.get(statEntry);
        if (func == null) {
            StatRollingData clone = null;
            this.writeLock.lock();
            try {
                int entryCount = this.statMap.size();
                if (entryCount < this.statLogger.getMaxEntryCount()) {
                    func = this.statMap.get(statEntry);
                    if (func == null) {
                        func = factory.create();
                        this.statMap.put(statEntry, func);
                    }
                } else {
                    HashMap<StatEntry, StatEntryFunc> cloneStatMap = new HashMap<StatEntry, StatEntryFunc>(this.statMap);
                    this.statMap.clear();
                    func = factory.create();
                    this.statMap.put(statEntry, func);
                    clone = new StatRollingData(this.statLogger, this.timeSlot, this.rollingTimeMillis, cloneStatMap);
                }
            }
            finally {
                this.writeLock.unlock();
            }
            if (clone != null) {
                StatLogController.scheduleWriteTask(clone);
            }
        }
        return func;
    }

    StatLogger getStatLogger() {
        return this.statLogger;
    }

    long getRollingTimeMillis() {
        return this.rollingTimeMillis;
    }

    long getTimeSlot() {
        return this.timeSlot;
    }

    int getStatCount() {
        return this.statMap.size();
    }

    Set<Map.Entry<StatEntry, StatEntryFunc>> getStatEntrySet() {
        return this.statMap.entrySet();
    }
}

