/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.rule;

import java.util.Objects;
import org.apache.shenyu.common.enums.HystrixIsolationModeEnum;

public class HystrixHandle {
    private String groupKey;
    private String commandKey;
    private int maxConcurrentRequests = 100;
    private int errorThresholdPercentage = 50;
    private int requestVolumeThreshold = 20;
    private int sleepWindowInMilliseconds = 5000;
    private long timeout = 3000L;
    private String callBackUri = "/fallback/hystrix";
    private int executionIsolationStrategy = HystrixIsolationModeEnum.SEMAPHORE.getCode();
    private HystrixThreadPoolConfig hystrixThreadPoolConfig;

    public static HystrixHandle newDefaultInstance() {
        return new HystrixHandle();
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getCommandKey() {
        return this.commandKey;
    }

    public void setCommandKey(String commandKey) {
        this.commandKey = commandKey;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public void setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    public int getErrorThresholdPercentage() {
        return this.errorThresholdPercentage;
    }

    public void setErrorThresholdPercentage(int errorThresholdPercentage) {
        this.errorThresholdPercentage = errorThresholdPercentage;
    }

    public int getRequestVolumeThreshold() {
        return this.requestVolumeThreshold;
    }

    public void setRequestVolumeThreshold(int requestVolumeThreshold) {
        this.requestVolumeThreshold = requestVolumeThreshold;
    }

    public int getSleepWindowInMilliseconds() {
        return this.sleepWindowInMilliseconds;
    }

    public void setSleepWindowInMilliseconds(int sleepWindowInMilliseconds) {
        this.sleepWindowInMilliseconds = sleepWindowInMilliseconds;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getCallBackUri() {
        return this.callBackUri;
    }

    public void setCallBackUri(String callBackUri) {
        this.callBackUri = callBackUri;
    }

    public int getExecutionIsolationStrategy() {
        return this.executionIsolationStrategy;
    }

    public void setExecutionIsolationStrategy(int executionIsolationStrategy) {
        this.executionIsolationStrategy = executionIsolationStrategy;
    }

    public HystrixThreadPoolConfig getHystrixThreadPoolConfig() {
        return this.hystrixThreadPoolConfig;
    }

    public void setHystrixThreadPoolConfig(HystrixThreadPoolConfig hystrixThreadPoolConfig) {
        this.hystrixThreadPoolConfig = hystrixThreadPoolConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        HystrixHandle that = (HystrixHandle)o;
        return this.maxConcurrentRequests == that.maxConcurrentRequests && this.errorThresholdPercentage == that.errorThresholdPercentage && this.requestVolumeThreshold == that.requestVolumeThreshold && this.sleepWindowInMilliseconds == that.sleepWindowInMilliseconds && this.timeout == that.timeout && this.executionIsolationStrategy == that.executionIsolationStrategy && Objects.equals(this.groupKey, that.groupKey) && Objects.equals(this.commandKey, that.commandKey) && Objects.equals(this.callBackUri, that.callBackUri) && Objects.equals(this.hystrixThreadPoolConfig, that.hystrixThreadPoolConfig);
    }

    public int hashCode() {
        return Objects.hash(this.groupKey, this.commandKey, this.maxConcurrentRequests, this.errorThresholdPercentage, this.requestVolumeThreshold, this.sleepWindowInMilliseconds, this.timeout, this.callBackUri, this.executionIsolationStrategy, this.hystrixThreadPoolConfig);
    }

    public String toString() {
        return "HystrixHandle{groupKey='" + this.groupKey + "', commandKey='" + this.commandKey + "', maxConcurrentRequests=" + this.maxConcurrentRequests + ", errorThresholdPercentage=" + this.errorThresholdPercentage + ", requestVolumeThreshold=" + this.requestVolumeThreshold + ", sleepWindowInMilliseconds=" + this.sleepWindowInMilliseconds + ", timeout=" + this.timeout + ", callBackUri='" + this.callBackUri + "', executionIsolationStrategy=" + this.executionIsolationStrategy + ", hystrixThreadPoolConfig=" + this.hystrixThreadPoolConfig + "}";
    }

    public static class HystrixThreadPoolConfig {
        private int coreSize = 10;
        private int maximumSize = 10;
        private int keepAliveTimeMinutes = 1;
        private int maxQueueSize = 12;

        public int getCoreSize() {
            return this.coreSize;
        }

        public void setCoreSize(int coreSize) {
            this.coreSize = coreSize;
        }

        public int getMaximumSize() {
            return this.maximumSize;
        }

        public void setMaximumSize(int maximumSize) {
            this.maximumSize = maximumSize;
        }

        public int getKeepAliveTimeMinutes() {
            return this.keepAliveTimeMinutes;
        }

        public void setKeepAliveTimeMinutes(int keepAliveTimeMinutes) {
            this.keepAliveTimeMinutes = keepAliveTimeMinutes;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (Objects.isNull(o) || this.getClass() != o.getClass()) {
                return false;
            }
            HystrixThreadPoolConfig that = (HystrixThreadPoolConfig)o;
            return this.coreSize == that.coreSize && this.maximumSize == that.maximumSize && this.keepAliveTimeMinutes == that.keepAliveTimeMinutes && this.maxQueueSize == that.maxQueueSize;
        }

        public int hashCode() {
            return Objects.hash(this.coreSize, this.maximumSize, this.keepAliveTimeMinutes, this.maxQueueSize);
        }

        public String toString() {
            return "HystrixThreadPoolConfig{coreSize=" + this.coreSize + ", maximumSize=" + this.maximumSize + ", keepAliveTimeMinutes=" + this.keepAliveTimeMinutes + ", maxQueueSize=" + this.maxQueueSize + "}";
        }
    }
}

