/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.client.ticket;

import com.qq.tars.net.client.Callback;
import com.qq.tars.net.client.ticket.Ticket;
import com.qq.tars.net.client.ticket.TimeoutManager;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.nio.SelectorManager;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TicketManager {
    private static ConcurrentHashMap<Integer, Ticket<?>> tickets = new ConcurrentHashMap();
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public static void shutdown() {
        executor.shutdownNow();
    }

    public static <T> Ticket<T> getTicket(int seq) {
        return tickets.get(seq);
    }

    public static <T> Ticket<T> createTicket(Request req, Session session, long timeout) {
        return TicketManager.createTicket(req, session, timeout, null);
    }

    public static <T> Ticket<T> createTicket(Request req, Session session, long timeout, Callback<T> callback) {
        if (req.getTicketNumber() == -1) {
            req.setTicketNumber(session.hashCode());
        }
        Ticket<T> ticket = new Ticket<T>(req, timeout);
        ticket.setCallback(callback);
        if (tickets.putIfAbsent(ticket.getTicketNumber(), ticket) != null) {
            throw new IllegalArgumentException("duplicate ticket number.");
        }
        if (ticket.getCallback() != null) {
            Future<?> timeoutTask = TimeoutManager.watch(new TimeoutManager.TimeoutTask(ticket), timeout);
            ticket.setTimeoutFuture(timeoutTask);
        }
        return ticket;
    }

    public static <T> Ticket<T> createTicket(Request req, Session session, long timeout, Callback<T> callback, SelectorManager selectorManager) {
        if (req.getTicketNumber() == -1) {
            req.setTicketNumber(session.hashCode());
        }
        Ticket<T> ticket = new Ticket<T>(req, timeout, selectorManager);
        ticket.setCallback(callback);
        if (tickets.putIfAbsent(ticket.getTicketNumber(), ticket) != null) {
            throw new IllegalArgumentException("duplicate ticket number.");
        }
        if (ticket.getCallback() != null) {
            Future<?> timeoutTask = TimeoutManager.watch(new TimeoutManager.TimeoutTask(ticket), timeout);
            ticket.setTimeoutFuture(timeoutTask);
        }
        return ticket;
    }

    public static void removeTicket(int ticketNumber) {
        tickets.remove(ticketNumber);
    }

    static {
        executor.scheduleAtFixedRate(new Runnable(){
            long currentTime = -1L;

            @Override
            public void run() {
                Collection values = tickets.values();
                this.currentTime = System.currentTimeMillis();
                for (Ticket t : values) {
                    if (this.currentTime - t.startTime <= t.timeout) continue;
                    TicketManager.removeTicket(t.getTicketNumber());
                    t.expired();
                }
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }
}

