/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.client;

import com.qq.tars.net.client.Callback;
import com.qq.tars.net.client.ticket.Ticket;
import com.qq.tars.net.client.ticket.TicketManager;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.TCPSession;
import com.qq.tars.net.core.nio.UDPSession;
import com.qq.tars.net.protocol.ProtocolFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Client<REQ extends Request, RES extends Response> {
    private Session session = null;
    private String host = null;
    private int port = -1;
    private SelectorManager selectorManager = null;
    private int minPoolSize = 5;
    private int maxPoolSize = 10;
    private int queueSize = 20000;
    private long readTimeout = 1000L;
    private long connectTimeout = 200L;
    private boolean keepAlive = true;
    private int selectorPoolSize = 2;
    private boolean udpMode = false;
    private int tc = -1;
    private int bufferSize = 4096;
    private boolean tcpNoDelay = false;
    private static final int INVALID_TRAFFIC_CLASS_VALUE = -1;
    protected static final ConcurrentHashMap<String, SelectorManager> selectors = new ConcurrentHashMap();

    public Client(String ip, int port, ProtocolFactory protocolFactory) {
        this(ip, port, protocolFactory, false);
    }

    public Client(String ip, int port, ProtocolFactory protocolFactory, boolean udpMode) {
        this(ip, port, protocolFactory, null, udpMode);
    }

    public Client(String ip, int port, ProtocolFactory protocolFactory, ThreadPoolExecutor threadPoolExecutor, boolean udpMode) {
        try {
            this.host = ip;
            this.port = port;
            this.udpMode = udpMode;
            this.selectorManager = this.initSelectorManager(protocolFactory, threadPoolExecutor);
            this.reConnect();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void ensureConnected() throws IOException {
        if (this.isNotConnected()) {
            this.reConnect();
        }
    }

    protected synchronized void reConnect() throws IOException {
        if (this.isNotConnected()) {
            int event;
            InetSocketAddress server = new InetSocketAddress(this.host, this.port);
            AbstractSelectableChannel channel = null;
            Session session2 = null;
            if (this.udpMode) {
                channel = DatagramChannel.open();
                ((SelectableChannel)channel).configureBlocking(false);
                session2 = new UDPSession(this.selectorManager);
                ((UDPSession)session2).setBufferSize(this.bufferSize);
                ((UDPSession)session2).setTarget(server);
                event = 1;
                session2.setStatus(Session.SessionStatus.CLIENT_CONNECTED);
            } else {
                channel = SocketChannel.open();
                ((SelectableChannel)channel).configureBlocking(false);
                try {
                    if (this.tc != -1) {
                        ((SocketChannel)channel).socket().setTrafficClass(this.tc);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ((SocketChannel)channel).connect(server);
                session2 = new TCPSession(this.selectorManager);
                ((TCPSession)session2).setTcpNoDelay(this.tcpNoDelay);
                event = 8;
            }
            session2.setChannel(channel);
            session2.setKeepAlive(this.selectorManager.isKeepAlive());
            this.selectorManager.nextReactor().registerChannel(channel, event, session2);
            if (!this.udpMode) {
                if (!session2.waitToConnect(this.connectTimeout)) {
                    session2.asyncClose();
                    throw new IOException("connect timed out to " + this.host + ":" + this.port);
                }
                if (session2.getStatus() == Session.SessionStatus.NOT_CONNECTED) {
                    session2.asyncClose();
                    throw new IOException("connect failed to " + this.host + ":" + this.port);
                }
                if (session2.getStatus() == Session.SessionStatus.CLOSED) {
                    throw new IOException("connect failed to " + this.host + ":" + this.port);
                }
            }
            this.session = session2;
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RES invokeWithSync(REQ request) throws IOException {
        Ticket ticket = null;
        Response response = null;
        try {
            this.ensureConnected();
            ((Request)request).setInvokeStatus(Request.InvokeStatus.SYNC_CALL);
            ticket = TicketManager.createTicket(request, this.session, this.getReadTimeout());
            Session session2 = this.session;
            session2.write((Request)request);
            if (!ticket.await(this.readTimeout, TimeUnit.MILLISECONDS)) {
                if (session2 != null && session2.getStatus() != Session.SessionStatus.CLIENT_CONNECTED) {
                    throw new IOException("Connection reset by peer");
                }
                throw new IOException("The operation has timed out.");
            }
            response = (Response)ticket.response();
            if (response == null) {
                throw new IOException("The operation is failed.");
            }
            Response response2 = response;
            return (RES)response2;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (ticket != null) {
                TicketManager.removeTicket(ticket.getTicketNumber());
            }
        }
        return (RES)response;
    }

    public void invokeWithAsync(REQ request, Callback<RES> callback) throws IOException {
        Ticket<RES> ticket = null;
        try {
            this.ensureConnected();
            ((Request)request).setInvokeStatus(Request.InvokeStatus.ASYNC_CALL);
            ticket = TicketManager.createTicket(request, this.session, this.getReadTimeout(), callback);
            this.session.write((Request)request);
        }
        catch (Exception ex) {
            if (ticket != null) {
                TicketManager.removeTicket(ticket.getTicketNumber());
            }
            throw new IOException("invokeWithAsync error:", ex);
        }
    }

    public synchronized void shutdown() throws IOException {
        this.session.asyncClose();
    }

    public Session getIoSession() {
        return this.session;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getTrafficClass() {
        return this.tc;
    }

    public void setTrafficClass(int tc) {
        if (this.session != null && this.session instanceof TCPSession) {
            try {
                ((SocketChannel)((TCPSession)this.session).getChannel()).socket().setTrafficClass(tc);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.tc = tc;
    }

    public void setTcpNoDelay(boolean on) {
        this.tcpNoDelay = on;
        if (this.session != null && this.session instanceof TCPSession) {
            try {
                ((SocketChannel)((TCPSession)this.session).getChannel()).socket().setTcpNoDelay(on);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    private boolean isNotConnected() {
        return this.session == null || this.session.getStatus() == Session.SessionStatus.CLOSED || this.session.getStatus() == Session.SessionStatus.NOT_CONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectorManager initSelectorManager(ProtocolFactory protocolFactory, ThreadPoolExecutor threadPoolExecutor) throws IOException {
        String protocolFactoryName = this.resolveProtocolFactoryName(protocolFactory);
        String currentContextIdentity = this.resolveCurrentContextIdentity();
        String key = protocolFactoryName + "-" + currentContextIdentity;
        ThreadPoolExecutor threadPool = null;
        SelectorManager selector = selectors.get(key);
        if (selector == null) {
            ConcurrentHashMap<String, SelectorManager> concurrentHashMap = selectors;
            synchronized (concurrentHashMap) {
                selector = selectors.get(key);
                if (selector == null) {
                    this.selectorPoolSize = this.convertInt(System.getProperty("com.qq.nami.client.selectorPoolSize"), this.selectorPoolSize);
                    this.minPoolSize = this.convertInt(System.getProperty("com.qq.nami.client.minPoolSize"), this.minPoolSize);
                    this.maxPoolSize = this.convertInt(System.getProperty("com.qq.nami.client.maxPoolSize"), this.maxPoolSize);
                    this.queueSize = this.convertInt(System.getProperty("com.qq.nami.client.queueSize"), this.queueSize);
                    threadPool = threadPoolExecutor == null ? new ThreadPoolExecutor(this.minPoolSize, this.maxPoolSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize)) : threadPoolExecutor;
                    selector = new SelectorManager(this.selectorPoolSize, protocolFactory, threadPool, null, this.keepAlive, "taserver-proxy", this.udpMode);
                    selector.start();
                    selectors.put(key, selector);
                }
            }
        }
        return selector;
    }

    private String resolveProtocolFactoryName(ProtocolFactory protocolFactory) {
        String protocolFactoryName = null;
        try {
            protocolFactoryName = protocolFactory.getClass().getName();
            Method method = protocolFactory.getClass().getMethod("getProtocolName", new Class[0]);
            protocolFactoryName = (String)method.invoke((Object)protocolFactory, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return protocolFactoryName;
    }

    private String resolveCurrentContextIdentity() {
        String contextIdentity = "";
        ClassLoader selfClassLoader = this.getClass().getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (selfClassLoader != null && contextClassLoader != null && selfClassLoader != contextClassLoader) {
            contextIdentity = contextClassLoader.toString();
        }
        return contextIdentity;
    }

    private int convertInt(String str, int defaults) {
        if (str == null) {
            return defaults;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaults;
        }
    }
}

