/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.BeanUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.ReflectUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperRegistryHelper
extends RegistryUtils {
    static List<ProviderInfo> convertUrlsToProviders(String providerPath, List<ChildData> currentData) throws UnsupportedEncodingException {
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        if (CommonUtils.isEmpty(currentData)) {
            return providerInfos;
        }
        for (ChildData childData : currentData) {
            providerInfos.add(ZookeeperRegistryHelper.convertUrlToProvider(providerPath, childData));
        }
        return providerInfos;
    }

    static ProviderInfo convertUrlToProvider(String providerPath, ChildData childData) throws UnsupportedEncodingException {
        String url = childData.getPath().substring(providerPath.length() + 1);
        url = URLDecoder.decode(url, "UTF-8");
        ProviderInfo providerInfo = ProviderHelper.toProviderInfo(url);
        ZookeeperRegistryHelper.processWarmUpWeight(providerInfo);
        return providerInfo;
    }

    static List<Map<String, String>> convertConfigToAttributes(String configPath, List<ChildData> currentData) {
        ArrayList<Map<String, String>> attributes = new ArrayList<Map<String, String>>();
        if (CommonUtils.isEmpty(currentData)) {
            return attributes;
        }
        for (ChildData childData : currentData) {
            attributes.add(ZookeeperRegistryHelper.convertConfigToAttribute(configPath, childData, false));
        }
        return attributes;
    }

    static Map<String, String> convertConfigToAttribute(String configPath, ChildData childData, boolean removeType) {
        String attribute = childData.getPath().substring(configPath.length() + 1);
        return Collections.singletonMap(attribute, removeType ? RpcConfigs.getStringValue(attribute) : StringSerializer.decode(childData.getData()));
    }

    static List<Map<String, String>> convertOverrideToAttributes(AbstractInterfaceConfig config, String overridePath, List<ChildData> currentData) throws UnsupportedEncodingException {
        ArrayList<Map<String, String>> attributes = new ArrayList<Map<String, String>>();
        if (CommonUtils.isEmpty(currentData)) {
            return attributes;
        }
        for (ChildData childData : currentData) {
            String url = URLDecoder.decode(childData.getPath().substring(overridePath.length() + 1), "UTF-8");
            if (!(config instanceof ConsumerConfig) || !StringUtils.isNotEmpty(url) || !StringUtils.isNotEmpty(SystemInfo.getLocalHost()) || !url.contains("://" + SystemInfo.getLocalHost() + "?")) continue;
            attributes.add(ZookeeperRegistryHelper.convertConfigToAttribute(overridePath, childData, false));
        }
        return attributes;
    }

    static Map<String, String> convertOverrideToAttribute(String overridePath, ChildData childData, boolean removeType, AbstractInterfaceConfig interfaceConfig) throws Exception {
        String url = URLDecoder.decode(childData.getPath().substring(overridePath.length() + 1), "UTF-8");
        ConcurrentHashMap<String, String> attribute = new ConcurrentHashMap<String, String>();
        for (String keyPairs : url.substring(url.indexOf(63) + 1).split("&")) {
            String[] overrideAttrs = keyPairs.split("=");
            List<String> configKeys = Arrays.asList("timeout", "serialization", "loadBalancer");
            if (!configKeys.contains(overrideAttrs[0])) continue;
            if (removeType) {
                Class clazz = null;
                if (interfaceConfig instanceof ProviderConfig) {
                    clazz = ProviderConfig.class;
                } else if (interfaceConfig instanceof ConsumerConfig) {
                    clazz = ConsumerConfig.class;
                }
                if (clazz == null) continue;
                Method getMethod = ReflectUtils.getPropertyGetterMethod(clazz, overrideAttrs[0]);
                Class<?> propertyClazz = getMethod.getReturnType();
                attribute.put(overrideAttrs[0], StringUtils.toString(BeanUtils.getProperty(interfaceConfig, overrideAttrs[0], propertyClazz)));
                continue;
            }
            attribute.put(overrideAttrs[0], overrideAttrs[1]);
        }
        return attribute;
    }

    static String buildOverridePath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/overrides";
    }
}

