/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.mesh.client;

import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.rpc.common.config.RpcConfigKeys;
import com.alipay.sofa.rpc.common.json.JSON;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.mesh.model.ApplicationInfoRequest;
import com.alipay.sofa.rpc.registry.mesh.model.ApplicationInfoResult;
import com.alipay.sofa.rpc.registry.mesh.model.PublishServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.PublishServiceResult;
import com.alipay.sofa.rpc.registry.mesh.model.SubscribeServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.SubscribeServiceResult;
import com.alipay.sofa.rpc.registry.mesh.model.UnPublishServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.UnPublishServiceResult;
import com.alipay.sofa.rpc.registry.mesh.model.UnSubscribeServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.UnSubscribeServiceResult;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;

public class MeshApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeshApiClient.class);
    private URI baseURI;
    private static int connectTimeout = (Integer)SofaConfigs.getOrDefault(RpcConfigKeys.MESH_HTTP_CONNECTION_TIMEOUT);
    private static int readTimeout = (Integer)SofaConfigs.getOrDefault(RpcConfigKeys.MESH_HTTP_READ_TIMEOUT);
    private static String errorMessage = "ERROR";
    private String host;
    private int port;

    public MeshApiClient(String meshAddress) {
        this.baseURI = URI.create(meshAddress);
        this.host = this.baseURI.getHost();
        this.port = this.baseURI.getPort();
    }

    public boolean publishService(PublishServiceRequest publishServiceRequest) {
        String json = JSON.toJSONString(publishServiceRequest);
        String result = this.httpPost("/services/publish", json);
        if (!StringUtils.equals(result, errorMessage)) {
            PublishServiceResult parse = JSON.parseObject(result, PublishServiceResult.class);
            return parse.isSuccess();
        }
        return false;
    }

    public boolean registeApplication(ApplicationInfoRequest applicationInfoRequest) {
        String json = applicationInfoRequest.toJson();
        String result = this.httpPost("/configs/application", json);
        if (!StringUtils.equals(result, errorMessage)) {
            ApplicationInfoResult parse = JSON.parseObject(result, ApplicationInfoResult.class);
            return parse.isSuccess();
        }
        return false;
    }

    public int unPublishService(UnPublishServiceRequest request) {
        String json = JSON.toJSONString(request);
        String result = this.httpPost("/services/unpublish", json);
        if (!StringUtils.equals(result, errorMessage)) {
            UnPublishServiceResult parse = JSON.parseObject(result, UnPublishServiceResult.class);
            if (parse.isSuccess()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public SubscribeServiceResult subscribeService(SubscribeServiceRequest subscribeServiceRequest) {
        String json = JSON.toJSONString(subscribeServiceRequest);
        String result = this.httpPost("/services/subscribe", json);
        if (!StringUtils.equals(result, errorMessage)) {
            SubscribeServiceResult subscribeServiceResult = JSON.parseObject(result, SubscribeServiceResult.class);
            return subscribeServiceResult;
        }
        SubscribeServiceResult subscribeServiceResult = new SubscribeServiceResult();
        return subscribeServiceResult;
    }

    public boolean unSubscribeService(UnSubscribeServiceRequest request) {
        String json = JSON.toJSONString(request);
        String result = this.httpPost("/services/unsubscribe", json);
        if (!StringUtils.equals(result, errorMessage)) {
            UnSubscribeServiceResult parse = JSON.parseObject(result, UnSubscribeServiceResult.class);
            return parse.isSuccess();
        }
        return false;
    }

    private HttpURLConnection createConnection(URL url, String method, boolean doOutput) {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(method);
            con.setConnectTimeout(connectTimeout);
            con.setReadTimeout(readTimeout);
            con.setDoOutput(doOutput);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "text/plain");
            return con;
        }
        catch (IOException e) {
            LOGGER.errorWithApp(null, "uri:" + url, e);
            return null;
        }
    }

    private String readDataFromConnection(HttpURLConnection con) {
        String result;
        int code = 0;
        try {
            code = con.getResponseCode();
            URL url = con.getURL();
            if (code == 200) {
                String temp;
                StringBuilder buffer = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
                while ((temp = br.readLine()) != null) {
                    buffer.append(temp);
                    buffer.append("\n");
                }
                result = buffer.toString().trim();
                LOGGER.infoWithApp(null, "uri:" + url + " return result: " + result);
            } else {
                LOGGER.infoWithApp(null, "uri:" + url + " return code: " + code);
                result = errorMessage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return errorMessage;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpGet(String path) {
        HttpURLConnection con = null;
        String result = null;
        try {
            URL url = this.baseURI.resolve(path).toURL();
            con = this.createConnection(url, "GET", false);
            con.connect();
            result = this.readDataFromConnection(con);
        }
        catch (Exception e) {
            LOGGER.errorWithApp(null, "uri:" + path + " return error: " + e.getMessage());
            result = errorMessage;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String httpPost(String path, String json) {
        HttpURLConnection con = null;
        String result = null;
        try {
            URL url = this.baseURI.resolve(path).toURL();
            con = this.createConnection(url, "POST", true);
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            out.write(json.getBytes("utf-8"));
            out.flush();
            out.close();
            result = this.readDataFromConnection(con);
        }
        catch (Exception e) {
            LOGGER.errorWithApp(null, "uri:" + path + " return error: " + e.getMessage());
            result = errorMessage;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

