/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.context;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.util.SafeConcurrentHashMap;
import com.alipay.sofa.rpc.message.ResponseFuture;
import java.util.Map;

public class RpcInvokeContext {
    protected static final ThreadLocal<RpcInvokeContext> LOCAL = new ThreadLocal();
    private static boolean BAGGAGE_ENABLE = RpcConfigs.getBooleanValue("invoke.baggage.enable");
    protected Map<String, String> customHeader = new SafeConcurrentHashMap<String, String>();
    protected Integer timeout;
    protected String targetURL;
    protected String targetGroup;
    protected SofaResponseCallback responseCallback;
    protected ResponseFuture<?> future;
    protected Map<String, Object> map = new SafeConcurrentHashMap<String, Object>();
    protected Map<String, String> requestBaggage = BAGGAGE_ENABLE ? new SafeConcurrentHashMap() : null;
    protected Map<String, String> responseBaggage = BAGGAGE_ENABLE ? new SafeConcurrentHashMap() : null;

    public static RpcInvokeContext getContext() {
        RpcInvokeContext context = LOCAL.get();
        if (context == null) {
            context = new RpcInvokeContext();
            LOCAL.set(context);
        }
        return context;
    }

    public static void setContext(RpcInvokeContext context) {
        LOCAL.set(RpcInvokeContext.clone(context));
    }

    private static RpcInvokeContext clone(RpcInvokeContext parent) {
        if (parent == null) {
            return null;
        }
        RpcInvokeContext child = new RpcInvokeContext();
        child.setTimeout(parent.getTimeout());
        child.setTargetURL(parent.getTargetURL());
        child.setTargetGroup(parent.getTargetGroup());
        child.setResponseCallback(parent.getResponseCallback());
        child.setFuture(parent.getFuture());
        child.map.putAll(parent.map);
        child.customHeader.putAll(parent.customHeader);
        if (BAGGAGE_ENABLE) {
            child.requestBaggage.putAll(parent.requestBaggage);
            child.responseBaggage.putAll(parent.responseBaggage);
        }
        return child;
    }

    public static RpcInvokeContext peekContext() {
        return LOCAL.get();
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    public static boolean isBaggageEnable() {
        return BAGGAGE_ENABLE;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public RpcInvokeContext setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public void put(String key, Object value) {
        if (key != null && value != null) {
            this.map.put(key, value);
        }
    }

    public Object get(String key) {
        if (key != null) {
            return this.map.get(key);
        }
        return null;
    }

    public Object remove(String key) {
        if (key != null) {
            return this.map.remove(key);
        }
        return null;
    }

    public void putRequestBaggage(String key, String value) {
        if (BAGGAGE_ENABLE && key != null && value != null) {
            this.requestBaggage.put(key, value);
        }
    }

    public String getRequestBaggage(String key) {
        if (BAGGAGE_ENABLE && key != null) {
            return this.requestBaggage.get(key);
        }
        return null;
    }

    public String removeRequestBaggage(String key) {
        if (BAGGAGE_ENABLE && key != null) {
            return this.requestBaggage.remove(key);
        }
        return null;
    }

    public Map<String, String> getAllRequestBaggage() {
        return this.requestBaggage;
    }

    public void putAllRequestBaggage(Map<String, String> requestBaggage) {
        if (BAGGAGE_ENABLE && requestBaggage != null) {
            this.putAllToBaggage(requestBaggage, this.requestBaggage);
        }
    }

    private void putAllToBaggage(Map<String, String> src, Map<String, String> dst) {
        for (Map.Entry<String, String> entry : src.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (value == null || key == null) continue;
            dst.put(key, value);
        }
    }

    public void putResponseBaggage(String key, String value) {
        if (BAGGAGE_ENABLE && key != null && value != null) {
            this.responseBaggage.put(key, value);
        }
    }

    public String getResponseBaggage(String key) {
        if (BAGGAGE_ENABLE && key != null) {
            return this.responseBaggage.get(key);
        }
        return null;
    }

    public String removeResponseBaggage(String key) {
        if (BAGGAGE_ENABLE && key != null) {
            return this.responseBaggage.remove(key);
        }
        return null;
    }

    public Map<String, String> getAllResponseBaggage() {
        return this.responseBaggage;
    }

    public void putAllResponseBaggage(Map<String, String> responseBaggage) {
        if (BAGGAGE_ENABLE && responseBaggage != null) {
            this.putAllToBaggage(responseBaggage, this.responseBaggage);
        }
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public RpcInvokeContext setTargetURL(String targetURL) {
        this.targetURL = targetURL;
        return this;
    }

    public String getTargetGroup() {
        return this.targetGroup;
    }

    public RpcInvokeContext setTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
        return this;
    }

    public SofaResponseCallback getResponseCallback() {
        return this.responseCallback;
    }

    public RpcInvokeContext setResponseCallback(SofaResponseCallback responseCallback) {
        this.responseCallback = responseCallback;
        return this;
    }

    public <T> ResponseFuture<T> getFuture() {
        return this.future;
    }

    public RpcInvokeContext setFuture(ResponseFuture<?> future) {
        this.future = future;
        return this;
    }

    public Map<String, String> getCustomHeader() {
        return this.customHeader;
    }

    public void addCustomHeader(String key, String value) {
        if (key != null && value != null) {
            this.customHeader.put(key, value);
        }
    }

    public void clearCustomHeader() {
        this.customHeader.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.toString());
        sb.append("{timeout=").append(this.timeout);
        sb.append(", targetURL='").append(this.targetURL).append('\'');
        sb.append(", targetGroup='").append(this.targetGroup).append('\'');
        sb.append(", responseCallback=").append(this.responseCallback);
        sb.append(", future=").append(this.future);
        sb.append(", map=").append(this.map);
        sb.append(", requestBaggage=").append(this.requestBaggage);
        sb.append(", responseBaggage=").append(this.responseBaggage);
        sb.append(", customHeader=").append(this.customHeader);
        sb.append('}');
        return sb.toString();
    }
}

