/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft.impl;

import com.alipay.sofa.rpc.client.aft.DegradeStrategy;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.MeasureResultDetail;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;

@Extension(value="log")
public class LogPrintDegradeStrategy
implements DegradeStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogPrintDegradeStrategy.class);

    @Override
    public void degrade(MeasureResultDetail measureResultDetail) {
        InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
        String appName = statDimension.getAppName();
        if (LOGGER.isInfoEnabled(appName)) {
            String service = statDimension.getService();
            long timeWindow = measureResultDetail.getTimeWindow();
            long windowCount = measureResultDetail.getWindowCount();
            double abnormalRate = measureResultDetail.getAbnormalRate();
            double averageAbnormalRate = measureResultDetail.getAverageAbnormalRate();
            String ip = statDimension.getIp();
            LOGGER.infoWithApp(appName, LogCodes.getLog("020140001", timeWindow, service, appName, windowCount, abnormalRate, averageAbnormalRate, ip));
        }
    }
}

