/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.resource.BatchResourceCreatedEvent;
import org.apache.shenyu.admin.model.event.resource.BatchResourceDeletedEvent;
import org.apache.shenyu.admin.model.event.resource.ResourceChangedEvent;
import org.apache.shenyu.admin.model.event.resource.ResourceCreatedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class ResourceEventPublisher
implements AdminDataModelChangedEventPublisher<ResourceDO> {
    private final ApplicationEventPublisher publisher;

    public ResourceEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(ResourceDO resource) {
        this.publish(new ResourceCreatedEvent(resource, SessionUtil.visitorName()));
    }

    @Override
    public void onCreated(Collection<ResourceDO> resource) {
        this.publish(new BatchResourceCreatedEvent(resource, "system"));
    }

    @Override
    public void onUpdated(ResourceDO resource, ResourceDO before) {
        this.publish(new ResourceChangedEvent(resource, before, EventTypeEnum.RULE_DELETE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(Collection<ResourceDO> data) {
        this.publish(new BatchResourceDeletedEvent(data, SessionUtil.visitorName()));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

