/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import org.apache.shenyu.admin.model.dto.InstanceInfoDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class InstanceInfoDO
extends BaseDO {
    private String instanceIp;
    private String instancePort;
    private String instanceType;
    private String instanceInfo;
    private Integer instanceState;
    private String namespaceId;

    public InstanceInfoDO() {
    }

    public InstanceInfoDO(String instanceIp, String instancePort, String instanceType, String instanceInfo) {
        this.instanceIp = instanceIp;
        this.instancePort = instancePort;
        this.instanceType = instanceType;
        this.instanceInfo = instanceInfo;
    }

    public InstanceInfoDO(String id, Timestamp dateCreated, Timestamp dateUpdated, String instanceIp, String instancePort, String instanceType, String instanceInfo) {
        super(id, dateCreated, dateUpdated);
        this.instanceIp = instanceIp;
        this.instancePort = instancePort;
        this.instanceType = instanceType;
        this.instanceInfo = instanceInfo;
    }

    public InstanceInfoDO(String id, Timestamp dateCreated, Timestamp dateUpdated, String instanceIp, String instancePort, String instanceType, String instanceInfo, String namespaceId) {
        super(id, dateCreated, dateUpdated);
        this.instanceIp = instanceIp;
        this.instancePort = instancePort;
        this.instanceType = instanceType;
        this.instanceInfo = instanceInfo;
        this.namespaceId = namespaceId;
    }

    public static InstanceInfoDO buildInstanceInfoDO(InstanceInfoDTO instanceInfoDTO) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        return InstanceInfoDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).instanceIp(instanceInfoDTO.getInstanceIp()).instancePort(instanceInfoDTO.getInstancePort()).instanceType(instanceInfoDTO.getInstanceType()).instanceInfo(instanceInfoDTO.getInstanceInfo()).instanceState(instanceInfoDTO.getInstanceState()).namespaceId(instanceInfoDTO.getNamespaceId()).dateCreated(currentTime).dateUpdated(currentTime).build();
    }

    public String getInstanceIp() {
        return this.instanceIp;
    }

    public void setInstanceIp(String instanceIp) {
        this.instanceIp = instanceIp;
    }

    public String getInstancePort() {
        return this.instancePort;
    }

    public void setInstancePort(String instancePort) {
        this.instancePort = instancePort;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceInfo() {
        return this.instanceInfo;
    }

    public void setInstanceInfo(String instanceInfo) {
        this.instanceInfo = instanceInfo;
    }

    public Integer getInstanceState() {
        return this.instanceState;
    }

    public void setInstanceState(Integer instanceState) {
        this.instanceState = instanceState;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public static InstanceInfoDOBuilder builder() {
        return new InstanceInfoDOBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstanceInfoDO instanceInfoDO = (InstanceInfoDO)o;
        return Objects.equals(this.instanceIp, instanceInfoDO.instanceIp) && Objects.equals(this.instancePort, instanceInfoDO.instancePort) && Objects.equals(this.instanceType, instanceInfoDO.instanceType) && Objects.equals(this.instanceInfo, instanceInfoDO.instanceInfo) && Objects.equals(this.instanceState, instanceInfoDO.instanceState) && Objects.equals(this.namespaceId, instanceInfoDO.namespaceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.instanceIp, this.instancePort, this.instanceType, this.instanceInfo, this.instanceState, this.namespaceId);
    }

    public static final class InstanceInfoDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String instanceIp;
        private String instancePort;
        private String instanceType;
        private String instanceInfo;
        private Integer instanceState;
        private String namespaceId;

        private InstanceInfoDOBuilder() {
        }

        public InstanceInfoDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InstanceInfoDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public InstanceInfoDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public InstanceInfoDOBuilder instanceIp(String instanceIp) {
            this.instanceIp = instanceIp;
            return this;
        }

        public InstanceInfoDOBuilder instancePort(String instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public InstanceInfoDOBuilder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public InstanceInfoDOBuilder instanceInfo(String instanceInfo) {
            this.instanceInfo = instanceInfo;
            return this;
        }

        public InstanceInfoDOBuilder instanceState(Integer instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public InstanceInfoDOBuilder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public InstanceInfoDO build() {
            InstanceInfoDO instanceInfoDO = new InstanceInfoDO();
            instanceInfoDO.setId(this.id);
            instanceInfoDO.setDateCreated(this.dateCreated);
            instanceInfoDO.setDateUpdated(this.dateUpdated);
            instanceInfoDO.setInstanceIp(this.instanceIp);
            instanceInfoDO.setInstancePort(this.instancePort);
            instanceInfoDO.setInstanceType(this.instanceType);
            instanceInfoDO.setInstanceInfo(this.instanceInfo);
            instanceInfoDO.setInstanceState(this.instanceState);
            instanceInfoDO.setNamespaceId(this.namespaceId);
            return instanceInfoDO;
        }
    }
}

