/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import jakarta.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.ConfigDataCache;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.http.HttpLongPollingDataChangedListener;
import org.apache.shenyu.admin.model.vo.NamespaceVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.NamespacePluginService;
import org.apache.shenyu.admin.service.NamespaceService;
import org.apache.shenyu.admin.service.ProxySelectorService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractDataChangedListener
implements DataChangedListener,
InitializingBean {
    protected static final ConcurrentMap<String, ConfigDataCache> CACHE = new ConcurrentHashMap<String, ConfigDataCache>();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataChangedListener.class);
    @Resource
    private AppAuthService appAuthService;
    @Resource
    private NamespacePluginService namespacePluginService;
    @Resource
    private RuleService ruleService;
    @Resource
    private SelectorService selectorService;
    @Resource
    private MetaDataService metaDataService;
    @Resource
    private ProxySelectorService proxySelectorService;
    @Resource
    private DiscoveryUpstreamService discoveryUpstreamService;
    @Resource
    private NamespaceService namespaceService;

    public ConfigData<?> fetchConfig(ConfigGroupEnum groupKey, String namespaceId) {
        ConfigDataCache config = (ConfigDataCache)CACHE.get(HttpLongPollingDataChangedListener.buildCacheKey(namespaceId, groupKey.name()));
        switch (groupKey) {
            case APP_AUTH: {
                return this.buildConfigData(config, AppAuthData.class);
            }
            case PLUGIN: {
                return this.buildConfigData(config, PluginData.class);
            }
            case RULE: {
                return this.buildConfigData(config, RuleData.class);
            }
            case SELECTOR: {
                return this.buildConfigData(config, SelectorData.class);
            }
            case META_DATA: {
                return this.buildConfigData(config, MetaData.class);
            }
            case PROXY_SELECTOR: {
                return this.buildConfigData(config, ProxySelectorData.class);
            }
            case DISCOVER_UPSTREAM: {
                return this.buildConfigData(config, DiscoverySyncData.class);
            }
        }
        throw new IllegalStateException("Unexpected groupKey: " + groupKey);
    }

    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        this.updateAppAuthCache(namespaceId);
        this.afterAppAuthChanged(changed, eventType, namespaceId);
    }

    protected void afterAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType, String namespaceId) {
    }

    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        this.updateMetaDataCache(namespaceId);
        this.afterMetaDataChanged(changed, eventType, namespaceId);
    }

    protected void afterMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType, String namespaceId) {
    }

    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        this.updatePluginCache(namespaceId);
        this.afterPluginChanged(changed, eventType, namespaceId);
    }

    protected void afterPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType, String namespaceId) {
    }

    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        this.updateRuleCache(namespaceId);
        this.afterRuleChanged(changed, eventType, namespaceId);
    }

    protected void afterRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType, String namespaceId) {
    }

    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        this.updateSelectorCache(namespaceId);
        this.afterSelectorChanged(changed, eventType, namespaceId);
    }

    public void onProxySelectorChanged(List<ProxySelectorData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        this.updateProxySelectorDataCache(namespaceId);
        this.afterProxySelectorChanged(changed, eventType, namespaceId);
    }

    protected void afterProxySelectorChanged(List<ProxySelectorData> changed, DataEventTypeEnum eventType, String namespaceId) {
    }

    public void onDiscoveryUpstreamChanged(List<DiscoverySyncData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        this.updateDiscoveryUpstreamDataCache(namespaceId);
        this.afterDiscoveryUpstreamDataChanged(changed, eventType, namespaceId);
    }

    protected void afterDiscoveryUpstreamDataChanged(List<DiscoverySyncData> changed, DataEventTypeEnum eventType, String namespaceId) {
    }

    protected void afterSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType, String namespaceId) {
    }

    public final void afterPropertiesSet() {
        this.refreshLocalCache();
        this.afterInitialize();
    }

    protected abstract void afterInitialize();

    protected <T> void updateCache(ConfigGroupEnum group, List<T> data, String namespaceId) {
        String json = GsonUtils.getInstance().toJson(data);
        String newMd5 = DigestUtils.md5Hex((String)json);
        ConfigDataCache oldConfig = (ConfigDataCache)CACHE.get(HttpLongPollingDataChangedListener.buildCacheKey(namespaceId, group.name()));
        if (Objects.nonNull(oldConfig) && StringUtils.isNotBlank((CharSequence)oldConfig.getMd5()) && oldConfig.getMd5().equals(newMd5)) {
            LOG.info("config cache[{}] is not changed, skip update.", (Object)group);
            return;
        }
        String configDataCacheKey = HttpLongPollingDataChangedListener.buildCacheKey(namespaceId, group.name());
        ConfigDataCache newVal = new ConfigDataCache(configDataCacheKey, json, newMd5, System.currentTimeMillis(), namespaceId);
        ConfigDataCache oldVal = CACHE.put(newVal.getGroup(), newVal);
        LOG.info("update config cache[{}], old: {}, updated: {}", new Object[]{group, oldVal, newVal});
    }

    protected void refreshLocalCache() {
        List<NamespaceVO> namespaceList = this.namespaceService.listAll();
        for (NamespaceVO namespace : namespaceList) {
            String namespaceId = namespace.getNamespaceId();
            this.updatePluginCache(namespaceId);
            this.updateAppAuthCache(namespaceId);
            this.updateRuleCache(namespaceId);
            this.updateSelectorCache(namespaceId);
            this.updateMetaDataCache(namespaceId);
            this.updateProxySelectorDataCache(namespaceId);
            this.updateDiscoveryUpstreamDataCache(namespaceId);
        }
    }

    protected void updateSelectorCache(String namespaceId) {
        this.updateCache(ConfigGroupEnum.SELECTOR, this.selectorService.listAll(), namespaceId);
    }

    protected void updateRuleCache(String namespaceId) {
        this.updateCache(ConfigGroupEnum.RULE, this.ruleService.listAll(), namespaceId);
    }

    protected void updatePluginCache(String namespaceId) {
        this.updateCache(ConfigGroupEnum.PLUGIN, this.namespacePluginService.listAll(namespaceId), namespaceId);
    }

    protected void updateAppAuthCache(String namespaceId) {
        this.updateCache(ConfigGroupEnum.APP_AUTH, this.appAuthService.listAll(), namespaceId);
    }

    protected void updateMetaDataCache(String namespaceId) {
        this.updateCache(ConfigGroupEnum.META_DATA, this.metaDataService.listAll(), namespaceId);
    }

    protected void updateProxySelectorDataCache(String namespaceId) {
        this.updateCache(ConfigGroupEnum.PROXY_SELECTOR, this.proxySelectorService.listAll(), namespaceId);
    }

    protected void updateDiscoveryUpstreamDataCache(String namespaceId) {
        this.updateCache(ConfigGroupEnum.DISCOVER_UPSTREAM, this.discoveryUpstreamService.listAll(), namespaceId);
    }

    private <T> ConfigData<T> buildConfigData(ConfigDataCache config, Class<T> dataType) {
        return new ConfigData(config.getMd5(), config.getLastModifyTime(), GsonUtils.getInstance().fromList(config.getJson(), dataType));
    }
}

