/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.Optional;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.LoginDashboardUserVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.service.EnumService;
import org.apache.shenyu.admin.service.SecretService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/platform"})
public class PlatformController {
    private final DashboardUserService dashboardUserService;
    private final EnumService enumService;
    private final SecretService secretService;

    public PlatformController(DashboardUserService dashboardUserService, EnumService enumService, SecretService secretService) {
        this.dashboardUserService = dashboardUserService;
        this.enumService = enumService;
        this.secretService = secretService;
    }

    @GetMapping(value={"/login"})
    public ShenyuAdminResult loginDashboardUser(String userName, String password, @RequestParam(required=false) String clientId) {
        LoginDashboardUserVO loginVO = this.dashboardUserService.login(userName, password, clientId);
        return Optional.ofNullable(loginVO).map(loginStatus -> {
            if (Boolean.TRUE.equals(loginStatus.getEnabled())) {
                return ShenyuAdminResult.success("login dashboard user success", loginVO);
            }
            return ShenyuAdminResult.error("the user is disabled");
        }).orElse(ShenyuAdminResult.error("username or password error"));
    }

    @GetMapping(value={"/enum"})
    public ShenyuAdminResult queryEnums() {
        return ShenyuAdminResult.success(this.enumService.list());
    }

    @GetMapping(value={"/secretInfo"})
    public ShenyuAdminResult info() {
        return ShenyuAdminResult.success(null, this.secretService.info());
    }
}

