/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.core.metrics;

import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class Buffer {
    private static final long signBit = Long.MIN_VALUE;
    private final AtomicLong observationCount = new AtomicLong(0L);
    private double[] observationBuffer = new double[0];
    private int bufferPos = 0;
    private boolean reset = false;
    private final Object appendLock = new Object();
    private final Object runLock = new Object();

    Buffer() {
    }

    boolean append(double value) {
        long count = this.observationCount.incrementAndGet();
        if ((count & Long.MIN_VALUE) == 0L) {
            return false;
        }
        this.doAppend(value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAppend(double amount) {
        Object object = this.appendLock;
        synchronized (object) {
            if (this.bufferPos >= this.observationBuffer.length) {
                this.observationBuffer = Arrays.copyOf(this.observationBuffer, this.observationBuffer.length + 128);
            }
            this.observationBuffer[this.bufferPos] = amount;
            ++this.bufferPos;
        }
    }

    void reset() {
        this.reset = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends DataPointSnapshot> T run(Function<Long, Boolean> complete, Supplier<T> runnable, Consumer<Double> observeFunction) {
        int bufferSize;
        double[] buffer;
        DataPointSnapshot result;
        Object object = this.runLock;
        synchronized (object) {
            int expectedBufferSize;
            Long count = this.observationCount.getAndAdd(Long.MIN_VALUE);
            while (!complete.apply(count).booleanValue()) {
                Thread.yield();
            }
            result = (DataPointSnapshot)runnable.get();
            if (this.reset) {
                expectedBufferSize = (int)((this.observationCount.getAndSet(0L) & Long.MAX_VALUE) - count);
                this.reset = false;
            } else {
                expectedBufferSize = (int)(this.observationCount.addAndGet(Long.MIN_VALUE) - count);
            }
            while (this.bufferPos != expectedBufferSize) {
                Thread.yield();
            }
            buffer = this.observationBuffer;
            bufferSize = this.bufferPos;
            this.observationBuffer = new double[0];
            this.bufferPos = 0;
        }
        for (int i = 0; i < bufferSize; ++i) {
            observeFunction.accept(buffer[i]);
        }
        return (T)result;
    }
}

