/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.flow;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterResponse;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.discovery.client.flow.RegisterStateManager;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RegisterFlow {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterFlow.class);
    private static final String HEADER_KEY_ASYNC_REGIS = "async-regis";
    private static final int HEARTBEAT_FAIL_COUNT_THRESHOLD = 2;
    private final SDKContext sdkContext;
    private final ScheduledThreadPoolExecutor asyncRegisterExecutor;

    public RegisterFlow(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
        this.asyncRegisterExecutor = new ScheduledThreadPoolExecutor(4, new NamedThreadFactory("async-register"));
    }

    public InstanceRegisterResponse registerInstance(InstanceRegisterRequest request, RegisterFunction registerFunction, HeartbeatFunction heartbeatFunction) {
        InstanceRegisterResponse instanceRegisterResponse = registerFunction.doRegister(request, this.createRegisterV2Header());
        RegisterStateManager.RegisterState registerState = RegisterStateManager.putRegisterState(this.sdkContext, request);
        if (registerState != null) {
            registerState.setTaskFuture(this.asyncRegisterExecutor.scheduleWithFixedDelay(() -> {
                try {
                    this.doRunHeartbeat(registerState, registerFunction, heartbeatFunction);
                }
                catch (Throwable e) {
                    LOG.error("[AsyncHeartbeat]Re-register instance failed, namespace:{}, service:{}, host:{}, port:{}", new Object[]{request.getNamespace(), request.getService(), request.getHost(), request.getPort(), e});
                }
            }, request.getTtl().intValue(), request.getTtl().intValue(), TimeUnit.SECONDS));
        }
        return instanceRegisterResponse;
    }

    private void doRunHeartbeat(RegisterStateManager.RegisterState registerState, RegisterFunction registerFunction, HeartbeatFunction heartbeatFunction) {
        InstanceRegisterRequest registerRequest = registerState.getInstanceRegisterRequest();
        LOG.debug("[AsyncHeartbeat]Instance heartbeat task started, namespace:{}, service:{}, host:{}, port:{}", new Object[]{registerRequest.getNamespace(), registerRequest.getService(), registerRequest.getHost(), registerRequest.getPort()});
        try {
            heartbeatFunction.doHeartbeat(this.buildHeartbeatRequest(registerRequest));
            LOG.info("[AsyncHeartbeat]Instance heartbeat success, namespace:{}, service:{}, host:{}, port:{}", new Object[]{registerRequest.getNamespace(), registerRequest.getService(), registerRequest.getHost(), registerRequest.getPort()});
            return;
        }
        catch (PolarisException e) {
            registerState.incrementFailCount();
            LOG.error("[AsyncHeartbeat]Instance heartbeat failed, namespace:{}, service:{}, host:{}, port:{}, serverErrCode:{}, heartbeat fail count:{}", new Object[]{registerRequest.getNamespace(), registerRequest.getService(), registerRequest.getHost(), registerRequest.getPort(), e.getServerErrCode(), registerState.getHeartbeatFailCounter()});
            long minRegisterInterval = this.sdkContext.getConfig().getProvider().getMinRegisterInterval();
            long sinceFirstRegister = System.currentTimeMillis() - registerState.getFirstRegisterTime();
            if (sinceFirstRegister < minRegisterInterval || registerState.getHeartbeatFailCounter() < 2) {
                return;
            }
            try {
                registerFunction.doRegister(registerRequest, this.createRegisterV2Header());
                LOG.info("[AsyncHeartbeat]Re-register instance success, namespace:{}, service:{}, host:{}, port:{}", new Object[]{registerRequest.getNamespace(), registerRequest.getService(), registerRequest.getHost(), registerRequest.getPort()});
                registerState.resetFailCount();
            }
            catch (PolarisException e2) {
                LOG.error("[AsyncHeartbeat]Re-register instance failed, namespace:{}, service:{}, host:{}, port:{}, serverErrCode:{}", new Object[]{registerRequest.getNamespace(), registerRequest.getService(), registerRequest.getHost(), registerRequest.getPort(), e2.getServerErrCode()});
            }
            return;
        }
    }

    private InstanceHeartbeatRequest buildHeartbeatRequest(InstanceRegisterRequest registerRequest) {
        InstanceHeartbeatRequest instanceHeartbeatRequest = new InstanceHeartbeatRequest();
        instanceHeartbeatRequest.setService(registerRequest.getService());
        instanceHeartbeatRequest.setNamespace(registerRequest.getNamespace());
        instanceHeartbeatRequest.setToken(registerRequest.getToken());
        instanceHeartbeatRequest.setHost(registerRequest.getHost());
        instanceHeartbeatRequest.setPort(registerRequest.getPort());
        instanceHeartbeatRequest.setInstanceID(registerRequest.getInstanceId());
        return instanceHeartbeatRequest;
    }

    private Map<String, String> createRegisterV2Header() {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put(HEADER_KEY_ASYNC_REGIS, "true");
        return header;
    }

    public void destroy() {
        this.asyncRegisterExecutor.shutdownNow();
    }

    @FunctionalInterface
    public static interface HeartbeatFunction {
        public void doHeartbeat(InstanceHeartbeatRequest var1);
    }

    @FunctionalInterface
    public static interface RegisterFunction {
        public InstanceRegisterResponse doRegister(InstanceRegisterRequest var1, Map<String, String> var2);
    }
}

