/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.ConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.ConfigFileRepoChangeListener;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.List;
import org.slf4j.Logger;
import shade.polaris.com.google.common.collect.Lists;

public abstract class AbstractConfigFileRepo
implements ConfigFileRepo {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigFileRepo.class);
    protected ConfigFileMetadata configFileMetadata;
    private final List<ConfigFileRepoChangeListener> listeners = Lists.newCopyOnWriteArrayList();
    protected SDKContext sdkContext;

    protected AbstractConfigFileRepo(SDKContext sdkContext, ConfigFileMetadata configFileMetadata) {
        this.sdkContext = sdkContext;
        this.configFileMetadata = configFileMetadata;
    }

    protected boolean pull() {
        try {
            this.doPull();
            return true;
        }
        catch (Throwable t) {
            LOGGER.warn("[Config] load config file failed. config file = {}", (Object)this.configFileMetadata, (Object)t);
            return false;
        }
    }

    protected abstract void doPull();

    @Override
    public void addChangeListener(ConfigFileRepoChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeChangeListener(ConfigFileRepoChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChangeEvent(String newContent) {
        for (ConfigFileRepoChangeListener listener : this.listeners) {
            try {
                listener.onChange(this.configFileMetadata, newContent);
            }
            catch (Throwable t) {
                LOGGER.error("[Config] invoke config file repo change listener failed. config file = {}, listener = {}", new Object[]{this.configFileMetadata, listener.getClass(), t});
            }
        }
    }

    public ConfigFileMetadata getConfigFileMetadata() {
        return this.configFileMetadata;
    }
}

