/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.registry;

import com.tencent.polaris.api.plugin.registry.CacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import java.util.function.Function;
import org.slf4j.Logger;

public abstract class AbstractCacheHandler
implements CacheHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCacheHandler.class);
    private static final String emptyReplaceHolder = "<empty>";

    protected abstract String getRevision(ResponseProto.DiscoverResponse var1);

    @Override
    public CacheHandler.CachedStatus compareMessage(RegistryCacheValue oldValue, Object newValue) {
        return AbstractCacheHandler.compareMessage(this.getTargetEventType(), oldValue, (ResponseProto.DiscoverResponse)newValue, new Function<ResponseProto.DiscoverResponse, String>(){

            @Override
            public String apply(ResponseProto.DiscoverResponse discoverResponse) {
                return AbstractCacheHandler.this.getRevision(discoverResponse);
            }
        });
    }

    public static CacheHandler.CachedStatus compareMessage(ServiceEventKey.EventType eventType, RegistryCacheValue oldValue, ResponseProto.DiscoverResponse discoverResponse, Function<ResponseProto.DiscoverResponse, String> getRevision) {
        CacheHandler.CachedStatus cachedStatus;
        String oldRevision;
        ServiceProto.Service service = discoverResponse.getService();
        ServiceEventKey serviceEventKey = new ServiceEventKey(new ServiceKey(service.getNamespace().getValue(), service.getName().getValue()), eventType);
        if (discoverResponse.getCode().getValue() == 200001) {
            if (null == oldValue) {
                return CacheHandler.CachedStatus.CacheEmptyButNoData;
            }
            return CacheHandler.CachedStatus.CacheNotChanged;
        }
        String newRevision = getRevision.apply(discoverResponse);
        boolean oldLoadedFromFile = false;
        if (null == oldValue) {
            oldRevision = emptyReplaceHolder;
            cachedStatus = CacheHandler.CachedStatus.CacheNotExists;
        } else {
            oldLoadedFromFile = oldValue.isLoadedFromFile();
            oldRevision = oldValue.getRevision();
            if (discoverResponse.getType() == ResponseProto.DiscoverResponse.DiscoverResponseType.SERVICES) {
                cachedStatus = CacheHandler.CachedStatus.CacheChanged;
            } else {
                CacheHandler.CachedStatus cachedStatus2 = cachedStatus = oldRevision.equals(newRevision) && !oldLoadedFromFile ? CacheHandler.CachedStatus.CacheNotChanged : CacheHandler.CachedStatus.CacheChanged;
            }
        }
        if (cachedStatus != CacheHandler.CachedStatus.CacheNotChanged) {
            LOG.info("resource {} has updated, compare status {}, old revision is {}, old loadedFromFile is {}, new revision is {}", new Object[]{serviceEventKey, cachedStatus, oldRevision, oldLoadedFromFile, newRevision});
        } else {
            LOG.debug("resource {} is not updated, compare status {}, old revision is {}, old loadedFromFile is {}, new revision is {}", new Object[]{serviceEventKey, cachedStatus, oldRevision, oldLoadedFromFile, newRevision});
        }
        return cachedStatus;
    }
}

