/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.apache.servicecomb.foundation.common.utils.SPIEnabled;
import org.apache.servicecomb.foundation.common.utils.SPIOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class BeanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);
    public static final String DEFAULT_BEAN_NORMAL_RESOURCE = "classpath*:META-INF/spring/*.bean.xml";
    public static final String[] DEFAULT_BEAN_RESOURCE = new String[]{"classpath*:META-INF/spring/*.bean.xml"};
    public static final String SCB_SCAN_PACKAGE = "scb-scan-package";
    private static final String SCB_PACKAGE = "org.apache.servicecomb";
    private static ApplicationContext context;

    private BeanUtils() {
    }

    public static void init() {
        BeanUtils.init(DEFAULT_BEAN_RESOURCE);
    }

    public static void init(String ... configLocations) {
        BeanUtils.prepareServiceCombScanPackage();
        LinkedHashSet<String> locationSet = new LinkedHashSet<String>();
        BeanUtils.addBeanLocation(locationSet, DEFAULT_BEAN_RESOURCE);
        BeanUtils.addBeanLocation(locationSet, configLocations);
        context = new ClassPathXmlApplicationContext(locationSet.toArray(new String[0]));
    }

    public static void initWithoutDefault(String ... configLocations) {
        BeanUtils.prepareServiceCombScanPackage();
        LinkedHashSet<String> locationSet = new LinkedHashSet<String>();
        BeanUtils.addBeanLocation(locationSet, configLocations);
        context = new ClassPathXmlApplicationContext(locationSet.toArray(new String[0]));
    }

    public static void addBeanLocation(Set<String> locationSet, String ... location) {
        Arrays.stream(location).forEach(loc -> BeanUtils.addBeanLocation(locationSet, loc));
    }

    public static void addBeanLocation(Set<String> locationSet, String location) {
        if (location == null) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)(location = location.trim()))) {
            locationSet.add(location);
        }
    }

    private static void addItem(Set<String> set, String item) {
        for (String it : set) {
            if (!item.startsWith(it)) continue;
            return;
        }
        set.add(item);
    }

    public static void prepareServiceCombScanPackage() {
        LinkedHashSet<String> scanPackages = new LinkedHashSet<String>();
        String exists = System.getProperty(SCB_SCAN_PACKAGE);
        if (exists != null) {
            for (String exist : exists.trim().split(",")) {
                if (exist.isEmpty()) continue;
                BeanUtils.addItem(scanPackages, exist.trim());
            }
        }
        BeanUtils.addItem(scanPackages, SCB_PACKAGE);
        for (Class mainClass : new Class[]{JvmUtils.findMainClass(), JvmUtils.findMainClassByStackTrace()}) {
            if (mainClass == null || mainClass.getPackage() == null) continue;
            String pkg = mainClass.getPackage().getName();
            BeanUtils.addItem(scanPackages, pkg);
        }
        String scbScanPackages = StringUtils.join(scanPackages, (String)",");
        System.setProperty(SCB_SCAN_PACKAGE, scbScanPackages);
        LOGGER.info("Scb scan package list: " + scbScanPackages);
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static void setContext(ApplicationContext applicationContext) {
        context = applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)context.getBean(name);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        if (context == null) {
            return Collections.emptyMap();
        }
        return context.getBeansOfType(type);
    }

    public static <T> T getBean(Class<T> type) {
        if (context == null) {
            return null;
        }
        return (T)context.getBean(type);
    }

    public static Class<?> getImplClassFromBean(Object bean) {
        return AopProxyUtils.ultimateTargetClass((Object)bean);
    }

    public static <T extends SPIOrder & SPIEnabled> void addBeans(Class<T> cls, List<T> exists) {
        if (context == null) {
            return;
        }
        for (SPIOrder instance : exists) {
            context.getAutowireCapableBeanFactory().autowireBean((Object)instance);
        }
        for (SPIOrder bean : context.getBeansOfType(cls).values()) {
            if (!((SPIEnabled)bean).enabled()) continue;
            exists.add(bean);
        }
        exists.sort(Comparator.comparingInt(rec$ -> ((SPIOrder)rec$).getOrder()));
    }
}

