/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.authentication.AuthenticationToken;
import org.apache.servicecomb.authentication.provider.AccessController;
import org.apache.servicecomb.foundation.common.utils.KeyPairUtils;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.cache.MicroserviceInstanceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderTokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderTokenManager.class);
    private final Cache<AuthenticationToken, Boolean> validatedToken = CacheBuilder.newBuilder().expireAfterAccess((long)this.getExpiredTime(), TimeUnit.MILLISECONDS).build();
    private final AccessController accessController = new AccessController();

    public boolean valid(String token) {
        try {
            AuthenticationToken rsaToken = AuthenticationToken.fromStr(token);
            if (null == rsaToken) {
                LOGGER.error("token format is error, perhaps you need to set auth handler at consumer");
                return false;
            }
            if (this.tokenExpired(rsaToken)) {
                LOGGER.error("token is expired");
                return false;
            }
            if (this.validatedToken.asMap().containsKey(rsaToken)) {
                return this.accessController.isAllowed(MicroserviceInstanceCache.getOrCreate((String)rsaToken.getServiceId()));
            }
            if (this.isValidToken(rsaToken) && !this.tokenExpired(rsaToken)) {
                this.validatedToken.put((Object)rsaToken, (Object)true);
                return this.accessController.isAllowed(MicroserviceInstanceCache.getOrCreate((String)rsaToken.getServiceId()));
            }
            return false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            LOGGER.error("verify error", (Throwable)e);
            return false;
        }
    }

    public boolean isValidToken(AuthenticationToken rsaToken) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        String sign = rsaToken.getSign();
        String content = rsaToken.plainToken();
        String publicKey = this.getPublicKeyFromInstance(rsaToken.getInstanceId(), rsaToken.getServiceId());
        return KeyPairUtils.verify((String)publicKey, (String)sign, (String)content);
    }

    protected int getExpiredTime() {
        return 3600000;
    }

    private boolean tokenExpired(AuthenticationToken rsaToken) {
        long generateTime = rsaToken.getGenerateTime();
        long expired = generateTime + 86400000L + 900000L;
        long now = System.currentTimeMillis();
        return now > expired;
    }

    private String getPublicKeyFromInstance(String instanceId, String serviceId) {
        MicroserviceInstance instances = MicroserviceInstanceCache.getOrCreate((String)serviceId, (String)instanceId);
        if (instances != null) {
            return (String)instances.getProperties().get("publickey");
        }
        LOGGER.error("not instance found {}-{}, maybe attack", (Object)instanceId, (Object)serviceId);
        return "";
    }

    @VisibleForTesting
    Cache<AuthenticationToken, Boolean> getValidatedToken() {
        return this.validatedToken;
    }
}

