/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import com.google.common.eventbus.EventBus;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;

@Path(value="/metrics")
public class MetricsRestPublisher
implements MetricsInitializer {
    private GlobalRegistry globalRegistry;

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.globalRegistry = globalRegistry;
    }

    @ApiResponses(value={@ApiResponse(code=400, response=String.class, message="illegal request content")})
    @GET
    @Path(value="/")
    public Map<String, Double> measure() {
        LinkedHashMap<String, Double> measurements = new LinkedHashMap<String, Double>();
        if (this.globalRegistry == null) {
            return measurements;
        }
        StringBuilder sb = new StringBuilder();
        for (Registry registry : this.globalRegistry.getRegistries()) {
            for (Meter meter : registry) {
                meter.measure().forEach(measurement -> {
                    String key = this.idToString(measurement.id(), sb);
                    measurements.put(key, measurement.value());
                });
            }
        }
        return measurements;
    }

    protected String idToString(Id id, StringBuilder sb) {
        sb.setLength(0);
        sb.append(id.name()).append('(');
        sb.append(StreamSupport.stream(id.tags().spliterator(), false).map(Object::toString).collect(Collectors.joining(",")));
        sb.append(')');
        return sb.toString();
    }
}

