/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.ws;

import com.netflix.config.DynamicPropertyFactory;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.filter.inner.ServerRestArgsFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.ws.ServerWebSocket;

public class ServerWebSocketArgsFilter
extends ServerRestArgsFilter {
    private static final boolean enabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.http.filter.server.serverWebSocketArgs.enabled", true).get();

    public boolean enabled() {
        return enabled;
    }

    public boolean enabledForTransport(String transport) {
        return "websocket".equals(transport);
    }

    public CompletableFuture<Void> beforeSendResponseAsync(Invocation invocation, HttpServletResponseEx responseEx) {
        Response response = (Response)responseEx.getAttribute("servicecomb-invocation-hanlder-response");
        if (response.getResult() instanceof ServerWebSocket) {
            return CompletableFuture.completedFuture(null);
        }
        return super.beforeSendResponseAsync(invocation, responseEx);
    }
}

