/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.exception;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionToProducerResponseConverters;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public final class ExceptionFactory {
    public static final int PRODUCER_INNER_STATUS_CODE = 590;
    public static final String PRODUCER_INNER_REASON_PHRASE = "Unexpected producer error, please check logs for details";
    public static final Response.StatusType PRODUCER_INNER_STATUS = new HttpStatus(590, "Unexpected producer error, please check logs for details");
    public static final int CONSUMER_INNER_STATUS_CODE = 490;
    public static final String CONSUMER_INNER_REASON_PHRASE = "Unexpected consumer error, please check logs for details";
    private static final ExceptionToProducerResponseConverters exceptionToProducerResponseConverters = (ExceptionToProducerResponseConverters)SPIServiceUtils.getPriorityHighestService(ExceptionToProducerResponseConverters.class);
    public static final Response.StatusType CONSUMER_INNER_STATUS = new HttpStatus(490, "Unexpected consumer error, please check logs for details");

    private ExceptionFactory() {
    }

    public static InvocationException create(Response.StatusType status, Object exceptionOrErrorData) {
        if (InvocationException.class.isInstance(exceptionOrErrorData)) {
            return (InvocationException)exceptionOrErrorData;
        }
        return ExceptionFactory.doCreate(status, exceptionOrErrorData);
    }

    public static InvocationException createConsumerException(Object errorData) {
        return ExceptionFactory.create(CONSUMER_INNER_STATUS, errorData);
    }

    public static InvocationException createProducerException(Object errorData) {
        return ExceptionFactory.create(PRODUCER_INNER_STATUS, errorData);
    }

    private static InvocationException doCreate(Response.StatusType status, Object errorData) {
        return new InvocationException(status, errorData);
    }

    private static InvocationException doCreate(int statusCode, String reasonPhrase, CommonExceptionData data, Throwable e) {
        return new InvocationException(statusCode, reasonPhrase, (Object)data, e);
    }

    public static InvocationException convertConsumerException(Throwable e) {
        return ExceptionFactory.convertException(490, CONSUMER_INNER_REASON_PHRASE, e, CONSUMER_INNER_REASON_PHRASE);
    }

    public static InvocationException convertConsumerException(Throwable e, String errorMsg) {
        return ExceptionFactory.convertException(490, CONSUMER_INNER_REASON_PHRASE, e, errorMsg);
    }

    public static InvocationException convertProducerException(Throwable e) {
        return ExceptionFactory.convertException(590, PRODUCER_INNER_REASON_PHRASE, e, PRODUCER_INNER_REASON_PHRASE);
    }

    public static InvocationException convertProducerException(Throwable e, String errorMsg) {
        return ExceptionFactory.convertException(590, PRODUCER_INNER_REASON_PHRASE, e, errorMsg);
    }

    private static InvocationException convertException(int statusCode, String reasonPhrase, Throwable e, String errorMsg) {
        if ((e = ExceptionFactory.unwrap(e)) instanceof InvocationException) {
            return (InvocationException)e;
        }
        CommonExceptionData data = new CommonExceptionData(errorMsg);
        return ExceptionFactory.doCreate(statusCode, reasonPhrase, data, e);
    }

    public static Response convertExceptionToResponse(SwaggerInvocation swaggerInvocation, Throwable e) {
        return exceptionToProducerResponseConverters.convertExceptionToResponse(swaggerInvocation, e);
    }

    public static Throwable unwrapIncludeInvocationException(Throwable throwable) {
        if ((throwable = ExceptionFactory.unwrap(throwable)) instanceof InvocationException) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static <T extends Throwable> T unwrap(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ExecutionException) {
            throwable = throwable.getCause();
        }
        return (T)throwable;
    }
}

