/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.registry.version.VersionRule;
import org.apache.servicecomb.registry.version.VersionRuleUtils;

public class CompatiblePathVersionMapper {
    private final Map<String, VersionRule> mapper = new ConcurrentHashMapEx();

    public VersionRule getOrCreate(String pathVersion) {
        return this.mapper.computeIfAbsent(pathVersion, this::createVersionRule);
    }

    protected VersionRule createVersionRule(String pathVersion) {
        if (StringUtils.isEmpty((CharSequence)pathVersion) || Character.toUpperCase(pathVersion.charAt(0)) != 'V') {
            throw new ServiceCombException(String.format("pathVersion \"%s\" is invalid, format must be v+number or V+number.", pathVersion));
        }
        int number = 0;
        try {
            number = Integer.parseInt(pathVersion.substring(1));
        }
        catch (NumberFormatException e) {
            throw new ServiceCombException(String.format("pathVersion \"%s\" is invalid, format must be v+number or V+number.", pathVersion), (Throwable)e);
        }
        if (number < 0 || number > Short.MAX_VALUE) {
            throw new ServiceCombException(String.format("pathVersion \"%s\" is invalid, version range is [0, %d].", pathVersion, (short)Short.MAX_VALUE));
        }
        if (number == Short.MAX_VALUE) {
            return VersionRuleUtils.getOrCreate((String)String.format("%d.0.0+", number));
        }
        return VersionRuleUtils.getOrCreate((String)String.format("%d.0.0-%d.0.0", number, number + 1));
    }
}

