/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.service;

import com.google.common.cache.Cache;
import org.apache.servicecomb.governance.service.GovernanceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceCacheImpl<K, V>
implements GovernanceCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(GovernanceCacheImpl.class);
    private final Cache<K, V> cache;

    public GovernanceCacheImpl(Cache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public V getValueFromCache(K cacheKey) {
        try {
            return (V)this.cache.getIfPresent(cacheKey);
        }
        catch (Exception exception) {
            LOG.warn("Failed to get a value from Cache", (Throwable)exception);
            return null;
        }
    }

    @Override
    public void putValueIntoCache(K cacheKey, V value) {
        try {
            this.cache.put(cacheKey, value);
        }
        catch (Exception exception) {
            LOG.warn("Failed to put a value into Cache {}", (Throwable)exception);
        }
    }
}

