<!--
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 -->

# Apache Sedona Python Documentation Color Scheme

## Updated Color Palette (Material Design Deep Orange + Black)

### Primary Colors

- **Deep Orange Primary**: `#ff5722` (used for headers, navigation, primary buttons)
- **Deep Orange Dark**: `#d84315` (used for hover states, headings)

### Accent Colors

- **Black Accent**: `#000000` (used for links, current navigation, highlights)
- **Black Accent Dark**: `#333333` (used for hover states on links)

### Supporting Colors

- **Dark Gray**: `#263238` (sidebar background)
- **Light Gray**: `#f5f5f5` (code backgrounds)
- **Secondary Gray**: `#e0e0e0` (borders, dividers)
- **Text**: `#333333` (main content text)
- **White**: `#ffffff` (content backgrounds)

## Color Usage

### Navigation

- Header: Deep Orange (`#ff5722`)
- Sidebar: Dark Gray (`#263238`)
- Current page: Deep Orange with Black accent border
- Links: Black accent (`#000000`)

### Content

- Headings: Deep Orange Dark (`#d84315`)
- Links: Black accent (`#000000`)
- Code blocks: Light Gray backgrounds
- Admonitions: Deep Orange borders with light orange backgrounds
- API documentation: Black accent borders

### Interactive Elements

- Buttons: Black accent backgrounds
- Hover states: Darker variants of respective colors
- Search focus: Black accent border

This color scheme uses Material Design deep orange primary with black accents for a professional, high-contrast appearance.
