/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.extractors;

import java.util.HashMap;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.model.OsmNode;

public class DenseNodeExtractor {
    long latOffset;
    long lonOffset;
    long granularity;
    long firstId = 0L;
    long firstLat = 0L;
    long firstLon = 0L;
    Integer keyIndex;
    Osmformat.DenseNodes nodes;

    public DenseNodeExtractor(Osmformat.DenseNodes nodes, long latOffset, long lonOffset, long granularity) {
        this.latOffset = latOffset;
        this.lonOffset = lonOffset;
        this.granularity = granularity;
        this.nodes = nodes;
        this.keyIndex = 0;
    }

    public OsmNode extract(int idx, Osmformat.StringTable stringTable) {
        return this.parse(idx, stringTable);
    }

    private OsmNode parse(int idx, Osmformat.StringTable stringTable) {
        long id = this.nodes.getId(idx) + this.firstId;
        long latitude = this.nodes.getLat(idx) + this.firstLat;
        long longitude = this.nodes.getLon(idx) + this.firstLon;
        double lat = 1.0E-9 * (double)(this.latOffset + latitude * this.granularity);
        double lon = 1.0E-9 * (double)(this.lonOffset + longitude * this.granularity);
        this.firstId = id;
        this.firstLat = latitude;
        this.firstLon = longitude;
        HashMap<String, String> tags = this.parseTags(stringTable);
        return new OsmNode(id, lat, lon, tags);
    }

    HashMap<String, String> parseTags(Osmformat.StringTable stringTable) {
        HashMap<String, String> tags = new HashMap<String, String>();
        while (this.nodes.getKeysVals(this.keyIndex) != 0) {
            int key = this.nodes.getKeysVals(this.keyIndex);
            int value = this.nodes.getKeysVals(this.keyIndex + 1);
            String keyString = stringTable.getS(key).toStringUtf8();
            String valueString = stringTable.getS(value).toStringUtf8();
            tags.put(keyString, valueString);
            this.keyIndex = this.keyIndex + 2;
        }
        this.keyIndex = this.keyIndex + 1;
        return tags;
    }
}

