/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.guava.collect.ImmutableSet;
import org.apache.sedona.shaded.guava.collect.Iterables;
import org.apache.sedona.shaded.guava.collect.Lists;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Cap;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2Loop;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polygon;
import org.apache.sedona.shaded.s2.S2Polyline;
import org.apache.sedona.shaded.s2.S2Predicates;

public final class S2ConvexHullQuery {
    private static final double OFFSET_FOR_SINGLE_POINT_LOOP = 1.0E-15;
    private final S2LatLngRect.Builder bound = S2LatLngRect.Builder.empty();
    private final List<S2Point> points = new ArrayList<S2Point>();

    public void addPoint(S2Point point) {
        this.bound.addPoint(point);
        this.points.add(point);
    }

    public void addPolyline(S2Polyline polyline) {
        this.bound.union(polyline.getRectBound());
        this.points.addAll(polyline.vertices());
    }

    public void addLoop(S2Loop loop) {
        if (loop.depth() != 0) {
            return;
        }
        this.bound.union(loop.getRectBound());
        if (loop.isEmptyOrFull()) {
            return;
        }
        for (int i = 0; i < loop.numVertices(); ++i) {
            this.points.add(loop.vertex(i));
        }
    }

    public void addPolygon(S2Polygon polygon) {
        for (int i = 0; i < polygon.numLoops(); ++i) {
            this.addLoop(polygon.loop(i));
        }
    }

    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    public S2Loop getConvexHull() {
        S2Cap cap = this.getCapBound();
        if (cap.height() >= 1.0) {
            return S2Loop.full();
        }
        S2Point origin = cap.axis().ortho();
        Collections.sort(this.points, new OrderedCcwAround(origin));
        ImmutableSet<S2Point> uniquePoints = ImmutableSet.copyOf(this.points);
        this.points.clear();
        this.points.addAll(uniquePoints);
        if (this.points.size() < 3) {
            if (this.points.isEmpty()) {
                return S2Loop.empty();
            }
            if (this.points.size() == 1) {
                return S2ConvexHullQuery.getSinglePointLoop(this.points.get(0));
            }
            return S2ConvexHullQuery.getSingleEdgeLoop(this.points.get(0), this.points.get(1));
        }
        Preconditions.checkState(S2Predicates.sign(origin, this.points.get(0), Iterables.getLast(this.points)) >= 0);
        List<S2Point> lower = S2ConvexHullQuery.getMonotoneChain(this.points);
        List<S2Point> upper = S2ConvexHullQuery.getMonotoneChain(Lists.reverse(this.points));
        Preconditions.checkState(lower.get(0).equals(Iterables.getLast(upper)));
        Preconditions.checkState(Iterables.getLast(lower).equals(upper.get(0)));
        lower.remove(lower.size() - 1);
        upper.remove(upper.size() - 1);
        lower.addAll(upper);
        return new S2Loop(lower);
    }

    private static List<S2Point> getMonotoneChain(List<S2Point> points) {
        ArrayList<S2Point> output = new ArrayList<S2Point>();
        for (S2Point p : points) {
            while (output.size() >= 2 && S2Predicates.sign((S2Point)output.get(output.size() - 2), Iterables.getLast(output), p) <= 0) {
                output.remove(output.size() - 1);
            }
            output.add(p);
        }
        return output;
    }

    private static S2Loop getSinglePointLoop(S2Point p) {
        S2Point d0 = S2.ortho(p);
        S2Point d1 = S2Point.crossProd(p, d0);
        return new S2Loop(ImmutableList.of(p, S2Point.normalize(S2Point.add(p, S2Point.mul(d0, 1.0E-15))), S2Point.normalize(S2Point.add(p, S2Point.mul(d1, 1.0E-15)))));
    }

    private static S2Loop getSingleEdgeLoop(S2Point a, S2Point b) {
        if (a.equalsPoint(b.neg())) {
            return S2Loop.full();
        }
        S2Loop loop = new S2Loop(ImmutableList.of(a, b, S2EdgeUtil.interpolate(0.5, a, b)));
        loop.normalize();
        return loop;
    }

    private static final class OrderedCcwAround
    implements Comparator<S2Point> {
        private final S2Point center;

        OrderedCcwAround(S2Point center) {
            this.center = center;
        }

        @Override
        public int compare(S2Point x, S2Point y) {
            if (this.lessThan(x, y)) {
                return -1;
            }
            if (this.lessThan(y, x)) {
                return 1;
            }
            return 0;
        }

        private boolean lessThan(S2Point x, S2Point y) {
            return S2Predicates.sign(this.center, x, y) > 0;
        }
    }
}

