/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.rangeJudgement;

import java.io.Serializable;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.core.spatialOperator.SpatialPredicateEvaluators;
import org.locationtech.jts.geom.Geometry;

public class JudgementBase<U extends Geometry>
implements Serializable {
    private final SpatialPredicateEvaluators.SpatialPredicateEvaluator evaluator;
    U queryGeometry;

    public JudgementBase(U queryWindow, SpatialPredicate spatialPredicate) {
        this.queryGeometry = queryWindow;
        this.evaluator = SpatialPredicateEvaluators.create(spatialPredicate);
    }

    public JudgementBase(U queryWindow, boolean considerBoundaryIntersection, boolean leftCoveredByRight) {
        this(queryWindow, JudgementBase.resolveSpatialPredicate(considerBoundaryIntersection, leftCoveredByRight));
    }

    public boolean match(Geometry spatialObject, Geometry queryWindow) {
        return this.evaluator.eval(spatialObject, queryWindow);
    }

    public static SpatialPredicate resolveSpatialPredicate(boolean considerBoundaryIntersection, boolean leftCoveredByRight) {
        if (considerBoundaryIntersection) {
            return SpatialPredicate.INTERSECTS;
        }
        return leftCoveredByRight ? SpatialPredicate.COVERED_BY : SpatialPredicate.COVERS;
    }
}

