/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EnumSet;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.GeographyCollection;
import org.apache.sedona.common.S2Geography.MultiPolygonGeography;
import org.apache.sedona.common.S2Geography.PointGeography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.PolylineGeography;
import org.apache.sedona.common.S2Geography.SinglePointGeography;
import org.apache.sedona.common.S2Geography.SinglePolylineGeography;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.util.Assert;

public class WKTWriter {
    private static final int INDENT = 2;
    private static final int OUTPUT_DIMENSION = 2;
    private boolean EWKT = false;
    private EnumSet<Ordinate> outputOrdinates;
    private final int outputDimension;
    private PrecisionModel precisionModel = null;
    private OrdinateFormat ordinateFormat = null;
    private boolean isFormatted = false;
    private int coordsPerLine = -1;
    private String indentTabStr;

    public static String toPoint(Coordinate p0) {
        return "POINT ( " + WKTWriter.format(p0) + " )";
    }

    public static String format(Coordinate p) {
        return WKTWriter.format(p.x, p.y);
    }

    private static String format(double x, double y) {
        return OrdinateFormat.DEFAULT.format(x) + " " + OrdinateFormat.DEFAULT.format(y);
    }

    private static OrdinateFormat createFormatter(PrecisionModel precisionModel) {
        return OrdinateFormat.create(precisionModel.getMaximumSignificantDigits());
    }

    private static String stringOfChar(char ch, int count) {
        StringBuilder buf = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public WKTWriter() {
        this(2);
    }

    public WKTWriter(boolean isEwkt) {
        this(2);
        this.EWKT = isEwkt;
    }

    public WKTWriter(int outputDimension) {
        this.setTab(2);
        this.outputDimension = outputDimension;
        this.setPrecisionModel(new PrecisionModel());
        if (outputDimension < 2 || outputDimension > 4) {
            throw new IllegalArgumentException("Invalid output dimension (must be 2 to 4)");
        }
        this.outputOrdinates = EnumSet.of(Ordinate.X, Ordinate.Y);
        if (outputDimension > 2) {
            this.outputOrdinates.add(Ordinate.Z);
        }
        if (outputDimension > 3) {
            this.outputOrdinates.add(Ordinate.M);
        }
    }

    public void setFormatted(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public void setMaxCoordinatesPerLine(int coordsPerLine) {
        this.coordsPerLine = coordsPerLine;
    }

    public void setTab(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Tab count must be positive");
        }
        this.indentTabStr = WKTWriter.stringOfChar(' ', size);
    }

    public void setOutputOrdinates(EnumSet<Ordinate> outputOrdinates) {
        this.outputOrdinates.remove((Object)Ordinate.Z);
        this.outputOrdinates.remove((Object)Ordinate.M);
        if (this.outputDimension == 3) {
            if (outputOrdinates.contains((Object)Ordinate.Z)) {
                this.outputOrdinates.add(Ordinate.Z);
            } else if (outputOrdinates.contains((Object)Ordinate.M)) {
                this.outputOrdinates.add(Ordinate.M);
            }
        }
        if (this.outputDimension == 4) {
            if (outputOrdinates.contains((Object)Ordinate.Z)) {
                this.outputOrdinates.add(Ordinate.Z);
            }
            if (outputOrdinates.contains((Object)Ordinate.M)) {
                this.outputOrdinates.add(Ordinate.M);
            }
        }
    }

    public EnumSet<Ordinate> getOutputOrdinates() {
        return this.outputOrdinates;
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
        this.ordinateFormat = OrdinateFormat.create(precisionModel.getMaximumSignificantDigits());
    }

    public String write(Geography geography) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geography, false, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void write(Geography geography, Writer writer) throws IOException {
        this.writeFormatted(geography, this.isFormatted, writer);
    }

    private void writeFormatted(Geography geography, boolean useFormatting, Writer writer) throws IOException {
        OrdinateFormat formatter = this.getFormatter(geography);
        this.appendGeometryTaggedText(geography, useFormatting, writer, formatter);
    }

    private OrdinateFormat getFormatter(Geography geography) {
        if (this.ordinateFormat != null) {
            return this.ordinateFormat;
        }
        PrecisionModel pm = this.precisionModel != null ? this.precisionModel : new PrecisionModel();
        this.ordinateFormat = WKTWriter.createFormatter(pm);
        return this.ordinateFormat;
    }

    private void appendGeometryTaggedText(Geography geography, boolean useFormatting, Writer writer, OrdinateFormat formatter) throws IOException {
        EnumSet<Ordinate> seq = this.getOutputOrdinates();
        this.appendGeometryTaggedText(geography, seq, useFormatting, 0, writer, formatter);
    }

    private void appendGeometryTaggedText(Geography geography, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        this.indent(useFormatting, level, writer);
        if (geography instanceof SinglePointGeography) {
            this.appendPointTaggedText((SinglePointGeography)geography, outputOrdinates, useFormatting, level, writer, formatter);
            return;
        }
        if (geography instanceof PointGeography) {
            this.appendMultiPointTaggedText((PointGeography)geography, outputOrdinates, useFormatting, level, writer, formatter);
            return;
        }
        if (geography instanceof SinglePolylineGeography) {
            this.appendPolylineTaggedText((SinglePolylineGeography)geography, outputOrdinates, useFormatting, level, writer, formatter);
            return;
        }
        if (geography instanceof PolylineGeography) {
            this.appendMultiLineStringTaggedText((PolylineGeography)geography, outputOrdinates, useFormatting, level, writer, formatter);
            return;
        }
        if (geography instanceof PolygonGeography) {
            this.appendPolygonTaggedText((PolygonGeography)geography, outputOrdinates, useFormatting, level, writer, formatter);
            return;
        }
        if (geography instanceof MultiPolygonGeography) {
            this.appendMultiPolygonTaggedText((MultiPolygonGeography)geography, outputOrdinates, useFormatting, level, writer, formatter);
            return;
        }
        if (geography instanceof GeographyCollection) {
            this.appendGeometryCollectionTaggedText((GeographyCollection)geography, outputOrdinates, useFormatting, level, writer, formatter);
            return;
        }
        Assert.shouldNeverReachHere("Unsupported Geometry implementation: " + String.valueOf(geography.getClass()));
    }

    public void writeSRID(Geography geography, Writer writer) throws IOException {
        if (geography == null || writer == null) {
            return;
        }
        int srid = geography.getSRID();
        if (srid > 0) {
            writer.write("SRID=");
            writer.write(Integer.toString(srid));
            writer.write(59);
            writer.write(32);
        }
    }

    private void appendPointTaggedText(PointGeography point, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (this.EWKT) {
            this.writeSRID(point, writer);
        }
        writer.write("POINT");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(point.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private void appendPolylineTaggedText(PolylineGeography lineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (this.EWKT) {
            this.writeSRID(lineString, writer);
        }
        writer.write("LINESTRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(lineString.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private void appendPolygonTaggedText(PolygonGeography polygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (this.EWKT) {
            this.writeSRID(polygon, writer);
        }
        writer.write("POLYGON");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendPolygonText(polygon, outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private void appendMultiPointTaggedText(PointGeography multipoint, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (this.EWKT) {
            this.writeSRID(multipoint, writer);
        }
        writer.write("MULTIPOINT");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiPointText(multipoint, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendMultiLineStringTaggedText(PolylineGeography multiLineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (this.EWKT) {
            this.writeSRID(multiLineString, writer);
        }
        writer.write("MULTILINESTRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiLineStringText(multiLineString, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendMultiPolygonTaggedText(MultiPolygonGeography multiPolygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (this.EWKT) {
            this.writeSRID(multiPolygon, writer);
        }
        writer.write("MULTIPOLYGON");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiPolygonText(multiPolygon, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendGeometryCollectionTaggedText(GeographyCollection geometryCollection, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (this.EWKT) {
            this.writeSRID(geometryCollection, writer);
        }
        writer.write("GEOMETRYCOLLECTION");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendGeometryCollectionText(geometryCollection, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendCoordinate(CoordinateSequence seq, EnumSet<Ordinate> outputOrdinates, int i, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write(WKTWriter.writeNumber(seq.getX(i), formatter) + " " + WKTWriter.writeNumber(seq.getY(i), formatter));
        if (outputOrdinates.contains((Object)Ordinate.Z)) {
            writer.write(" ");
            writer.write(WKTWriter.writeNumber(seq.getZ(i), formatter));
        }
        if (outputOrdinates.contains((Object)Ordinate.M)) {
            writer.write(" ");
            writer.write(WKTWriter.writeNumber(seq.getM(i), formatter));
        }
    }

    private static String writeNumber(double d, OrdinateFormat formatter) {
        return formatter.format(d);
    }

    private void appendOrdinateText(EnumSet<Ordinate> outputOrdinates, Writer writer) throws IOException {
        if (outputOrdinates.contains((Object)Ordinate.Z)) {
            writer.append("Z");
        }
        if (outputOrdinates.contains((Object)Ordinate.M)) {
            writer.append("M");
        }
    }

    private void appendSequenceText(CoordinateSequence seq, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, boolean indentFirst, Writer writer, OrdinateFormat formatter) throws IOException {
        if (seq.size() == 0) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(useFormatting, level, writer);
            }
            writer.write("(");
            for (int i = 0; i < seq.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i % this.coordsPerLine == 0) {
                        this.indent(useFormatting, level + 1, writer);
                    }
                }
                this.appendCoordinate(seq, outputOrdinates, i, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendPolygonText(PolygonGeography polygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, boolean indentFirst, Writer writer, OrdinateFormat formatter) throws IOException {
        if (polygon == null || polygon.polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(useFormatting, level, writer);
            }
            writer.write("(");
            this.appendSequenceText(polygon.getExteriorRing().getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
            for (LineString lineString : polygon.getLoops()) {
                writer.write(", ");
                this.appendSequenceText(lineString.getCoordinateSequence(), outputOrdinates, useFormatting, level + 1, true, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendMultiPointText(PointGeography multiPoint, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiPoint.numShapes() == 0) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            CoordinateSequence sequence = multiPoint.getCoordinateSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    this.indentCoords(useFormatting, i, level + 1, writer);
                }
                this.appendSequenceText(new SinglePointGeography(multiPoint.getPoints().get(i)).getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendMultiLineStringText(PolylineGeography multiLineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiLineString.numShapes() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            for (int i = 0; i < multiLineString.numShapes(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendSequenceText(new SinglePolylineGeography(multiLineString.getPolylines().get(i)).getCoordinateSequence(), outputOrdinates, useFormatting, level2, doIndent, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendMultiPolygonText(MultiPolygonGeography multiPolygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiPolygon.numShapes() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            for (int i = 0; i < multiPolygon.numShapes(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendPolygonText((PolygonGeography)multiPolygon.getFeatures().get(i), outputOrdinates, useFormatting, level2, doIndent, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendGeometryCollectionText(GeographyCollection geometryCollection, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (geometryCollection.numShapes() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            writer.write("(");
            for (int i = 0; i < geometryCollection.numShapes(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getFeatures().get(i), outputOrdinates, useFormatting, level2, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void indentCoords(boolean useFormatting, int coordIndex, int level, Writer writer) throws IOException {
        if (this.coordsPerLine <= 0 || coordIndex % this.coordsPerLine != 0) {
            return;
        }
        this.indent(useFormatting, level, writer);
    }

    private void indent(boolean useFormatting, int level, Writer writer) throws IOException {
        if (!useFormatting || level <= 0) {
            return;
        }
        writer.write("\n");
        for (int i = 0; i < level; ++i) {
            writer.write(this.indentTabStr);
        }
    }
}

