/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetOptions$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.RebaseSpec;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.RebaseSpec$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DataSourceUtils$
implements PredicateHelper {
    public static final DataSourceUtils$ MODULE$ = new DataSourceUtils$();
    private static final String SPARK_VERSION_METADATA_KEY;
    private static final String SPARK_TIMEZONE_METADATA_KEY;
    private static final String SPARK_LEGACY_DATETIME_METADATA_KEY;
    private static final String SPARK_LEGACY_INT96_METADATA_KEY;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        AliasHelper.$init$((AliasHelper)MODULE$);
        Logging.$init$((Logging)MODULE$);
        PredicateHelper.$init$((PredicateHelper)MODULE$);
        SPARK_VERSION_METADATA_KEY = "org.apache.spark.version";
        SPARK_TIMEZONE_METADATA_KEY = "org.apache.spark.timeZone";
        SPARK_LEGACY_DATETIME_METADATA_KEY = "org.apache.spark.legacyDateTime";
        SPARK_LEGACY_INT96_METADATA_KEY = "org.apache.spark.legacyINT96";
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String SPARK_VERSION_METADATA_KEY() {
        return SPARK_VERSION_METADATA_KEY;
    }

    public String SPARK_TIMEZONE_METADATA_KEY() {
        return SPARK_TIMEZONE_METADATA_KEY;
    }

    public String SPARK_LEGACY_DATETIME_METADATA_KEY() {
        return SPARK_LEGACY_DATETIME_METADATA_KEY;
    }

    public String SPARK_LEGACY_INT96_METADATA_KEY() {
        return SPARK_LEGACY_INT96_METADATA_KEY;
    }

    /*
     * Unable to fully structure code
     */
    private RebaseSpec getRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig, String minVersion, String metadataKey) {
        if (!Utils$.MODULE$.isTesting()) ** GOTO lbl-1000
        v0 = PortableSQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
        var7_5 = "true";
        if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
            v1 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        } else lbl-1000:
        // 2 sources

        {
            v1 = (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)this.SPARK_VERSION_METADATA_KEY())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getRebaseSpec$1(java.lang.String scala.Function1 java.lang.String java.lang.String ), (Ljava/lang/String;)Lscala/Enumeration$Value;)((String)minVersion, lookupFileMeta, (String)metadataKey)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getRebaseSpec$2(java.lang.String ), ()Lscala/Enumeration$Value;)((String)modeByConfig));
        }
        var8_7 = policy = v1;
        v2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        var9_8 = var8_7;
        if (!(v2 != null ? v2.equals(var9_8) == false : var9_8 != null)) {
            return new RebaseSpec(LegacyBehaviorPolicy$.MODULE$.LEGACY(), (Option<String>)Option$.MODULE$.apply(lookupFileMeta.apply((Object)this.SPARK_TIMEZONE_METADATA_KEY())));
        }
        return new RebaseSpec(policy, RebaseSpec$.MODULE$.apply$default$2());
    }

    public RebaseSpec datetimeRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.0.0", this.SPARK_LEGACY_DATETIME_METADATA_KEY());
    }

    public RebaseSpec int96RebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.1.0", this.SPARK_LEGACY_INT96_METADATA_KEY());
    }

    public RuntimeException newRebaseExceptionInRead(String format) {
        Tuple2 tuple2;
        block6: {
            String string = format;
            switch (string == null ? 0 : string.hashCode()) {
                case -2017918496: {
                    if (!"Parquet INT96".equals(string)) break;
                    tuple2 = new Tuple2((Object)PortableSQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.INT96_REBASE_MODE());
                    break block6;
                }
                case 2053458: {
                    if (!"Avro".equals(string)) break;
                    tuple2 = new Tuple2((Object)PortableSQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key(), (Object)"datetimeRebaseMode");
                    break block6;
                }
                case 871641556: {
                    if (!"Parquet".equals(string)) break;
                    tuple2 = new Tuple2((Object)PortableSQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.DATETIME_REBASE_MODE());
                    break block6;
                }
            }
            throw new IllegalStateException(new StringBuilder(21).append("Unrecognized format ").append(format).append(".").toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String config = (String)tuple22._1();
        String option = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)config, (Object)option);
        String config2 = (String)tuple23._1();
        String option2 = (String)tuple23._2();
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInReadingDatesError(format, config2, option2);
    }

    public RuntimeException newRebaseExceptionInWrite(String format) {
        String string;
        block5: {
            String string2 = format;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -2017918496: {
                    if (!"Parquet INT96".equals(string2)) break;
                    string = PortableSQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE().key();
                    break block5;
                }
                case 2053458: {
                    if (!"Avro".equals(string2)) break;
                    string = PortableSQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE().key();
                    break block5;
                }
                case 871641556: {
                    if (!"Parquet".equals(string2)) break;
                    string = PortableSQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE().key();
                    break block5;
                }
            }
            throw new IllegalStateException(new StringBuilder(21).append("Unrecognized format ").append(format).append(".").toString());
        }
        String config = string;
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInWritingDatesError(format, config);
    }

    public Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createTimestampRebaseFuncInRead(RebaseSpec rebaseSpec, String format) {
        Enumeration.Value value = rebaseSpec.mode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x$2 -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(rebaseSpec.timeZone(), x$2);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            String timeZone = PortableSQLConf$.MODULE$.get().sessionLocalTimeZone();
            return (JFunction1.mcJJ.sp & Serializable)x$3 -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(timeZone, x$3);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$1(String minVersion$1, Function1 lookupFileMeta$1, String metadataKey$1, String version) {
        if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(version), minVersion$1) || lookupFileMeta$1.apply((Object)metadataKey$1) != null) {
            return LegacyBehaviorPolicy$.MODULE$.LEGACY();
        }
        return LegacyBehaviorPolicy$.MODULE$.CORRECTED();
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$2(String modeByConfig$1) {
        return LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig$1);
    }

    private DataSourceUtils$() {
    }
}

