/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geometrySerde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import org.apache.sedona.common.geometrySerde.GeometrySerde;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.index.strtree.IndexSerde;
import org.locationtech.jts.index.strtree.STRtree;

public class SpatialIndexSerde
extends Serializer
implements Serializable {
    private final GeometrySerde geometrySerde;

    public SpatialIndexSerde() {
        this.geometrySerde = new GeometrySerde();
    }

    public SpatialIndexSerde(GeometrySerde geometrySerde) {
        this.geometrySerde = geometrySerde;
    }

    public void write(Kryo kryo, Output output, Object o) {
        if (o instanceof Quadtree) {
            this.writeType(output, Type.QUADTREE);
            Quadtree tree = (Quadtree)o;
            org.locationtech.jts.index.quadtree.IndexSerde indexSerde = new org.locationtech.jts.index.quadtree.IndexSerde();
            indexSerde.write(kryo, output, tree);
        } else if (o instanceof STRtree) {
            this.writeType(output, Type.RTREE);
            STRtree tree = (STRtree)o;
            IndexSerde indexSerde = new IndexSerde();
            indexSerde.write(kryo, output, tree);
        } else {
            throw new UnsupportedOperationException(" index type not supported ");
        }
    }

    public Object read(Kryo kryo, Input input, Class aClass) {
        byte typeID = input.readByte();
        Type indexType = Type.fromId(typeID);
        switch (indexType) {
            case QUADTREE: {
                org.locationtech.jts.index.quadtree.IndexSerde indexSerde = new org.locationtech.jts.index.quadtree.IndexSerde();
                return indexSerde.read(kryo, input);
            }
            case RTREE: {
                IndexSerde indexSerde = new IndexSerde();
                return indexSerde.read(kryo, input);
            }
        }
        throw new UnsupportedOperationException("can't deserialize spatial index of type" + indexType);
    }

    private void writeType(Output output, Type type) {
        output.writeByte((byte)type.id);
    }

    private static enum Type {
        QUADTREE(0),
        RTREE(1);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public static Type fromId(int id) {
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }
}

