/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import java.io.IOException;
import java.util.List;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.shaded.s2.S2CellId;

public class EncodeTag {
    private Geography.GeographyKind kind = Geography.GeographyKind.UNINITIALIZED;
    private byte flags = 0;
    public static final byte FLAG_EMPTY = 1;
    public static final byte FLAG_COMPACT = 2;
    private byte coveringSize = 0;
    private byte reserved = 0;

    public EncodeTag() {
    }

    public EncodeTag(EncodeOptions opts) {
        if (opts.getCodingHint() == EncodeOptions.CodingHint.COMPACT) {
            this.flags = (byte)(this.flags | 2);
        }
    }

    public void encode(Output out) throws IOException {
        out.writeByte(this.kind.getKind());
        out.writeByte(this.flags);
        out.writeByte(this.coveringSize);
        out.writeByte(this.reserved);
    }

    public static EncodeTag decode(Input in) throws IOException {
        EncodeTag tag = new EncodeTag();
        tag.kind = Geography.GeographyKind.fromKind(in.readByte());
        tag.flags = in.readByte();
        tag.coveringSize = in.readByte();
        tag.reserved = in.readByte();
        if (tag.reserved != 0) {
            throw new IOException("Reserved header byte must be 0, was " + tag.reserved);
        }
        return tag;
    }

    public void decodeCovering(UnsafeInput in, List<S2CellId> cellIds) throws IOException {
        int count = this.coveringSize & 0xFF;
        for (int i = 0; i < count; ++i) {
            long id = in.readLong();
            cellIds.add(new S2CellId(id));
        }
    }

    public void skipCovering(UnsafeInput in) throws IOException {
        int count = this.coveringSize & 0xFF;
        for (int i = 0; i < count; ++i) {
            in.readLong();
        }
    }

    public void validate() {
        if (this.reserved != 0) {
            throw new IllegalStateException("EncodeTag.reserved must be 0, was " + (this.reserved & 0xFF));
        }
    }

    public Geography.GeographyKind getKind() {
        return this.kind;
    }

    public void setKind(Geography.GeographyKind kind) {
        this.kind = kind;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public byte getCoveringSize() {
        return this.coveringSize;
    }

    public void setCoveringSize(byte size) {
        this.coveringSize = size;
    }

    public void setEmpty(boolean empty) {
        this.flags = empty ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public void setCompact(boolean compact) {
        this.flags = compact ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public boolean isEmpty() {
        return (this.flags & 1) != 0;
    }

    public boolean isCompact() {
        return (this.flags & 2) != 0;
    }

    public boolean isFast() {
        return !this.isCompact();
    }
}

