/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.jpostal;

import com.mapzen.jpostal.AddressExpander;
import com.mapzen.jpostal.AddressParser;
import com.mapzen.jpostal.Config;
import com.mapzen.jpostal.DataDownloadUtils;

final class LibPostal {
    private final Config config;
    private static volatile LibPostal instance = null;

    private LibPostal(Config config) {
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        config.loadLibrary();
        String dataDir = config.getDataDir();
        if (dataDir == null) {
            LibPostal.setup();
        } else {
            LibPostal.setupDataDir(dataDir);
        }
        this.config = config;
    }

    Config getConfig() {
        return this.config;
    }

    private static native void setup();

    private static native void setupDataDir(String var0);

    private static native void teardown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static LibPostal getInstance() {
        if (instance != null) return instance;
        Class<LibPostal> clazz = LibPostal.class;
        synchronized (LibPostal.class) {
            if (instance != null) return instance;
            instance = new LibPostal(Config.builder().build());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LibPostal getInstance(Config config) {
        if (instance == null) {
            Class<LibPostal> clazz = LibPostal.class;
            synchronized (LibPostal.class) {
                if (instance == null) {
                    if (config.getDownloadDataIfNeeded().booleanValue() && !DataDownloadUtils.isDataDirPopulated(config.getDataDir()).booleanValue()) {
                        DataDownloadUtils.populateDataDir(config.getDataDir(), config.getSenzing());
                    }
                    instance = new LibPostal(config);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (!LibPostal.instance.config.equals(config)) {
            throw Config.mismatchException(LibPostal.instance.config, config);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        AddressParser._close();
        AddressExpander._close();
        Class<LibPostal> clazz = LibPostal.class;
        synchronized (LibPostal.class) {
            if (instance != null) {
                LibPostal.teardown();
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected void finalize() {
        LibPostal.teardown();
    }
}

