/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.connectors.seatunnel.paimon.source;

import org.apache.seatunnel.api.source.SourceSplit;

import org.apache.paimon.table.source.Split;

import lombok.Getter;

/** Paimon source split, wrapped the {@link Split} of paimon table. */
@Getter
public class PaimonSourceSplit implements SourceSplit {
    private static final long serialVersionUID = 1L;

    /** The unique ID of the split. Unique within the scope of this source. */
    private final String id;

    private final String tableId;

    private final Split split;

    public PaimonSourceSplit(String id, String tableId, Split split) {
        this.id = id;
        this.tableId = tableId;
        this.split = split;
    }

    @Override
    public String splitId() {
        return split.toString();
    }
}
