/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.EnumSet;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.problems.ImplicitCoercionToUnrelatedTypeProblem;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLExpressionNode;

abstract class MXMLExpressionNodeBase
extends MXMLInstanceNode
implements IMXMLExpressionNode {
    protected static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE);
    private IASNode expressionNode;

    MXMLExpressionNodeBase(NodeBase parent) {
        super(parent);
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.expressionNode : null;
    }

    @Override
    public int getChildCount() {
        return this.expressionNode == null ? 0 : 1;
    }

    @Override
    public IASNode getExpressionNode() {
        return this.expressionNode;
    }

    public void setExpressionNode(NodeBase value) {
        this.expressionNode = value;
        if (value != null) {
            value.setParent(this);
        }
    }

    public abstract ExpressionType getExpressionType();

    public void initialize(MXMLTreeBuilder builder, ISourceLocation location, String type, NodeBase expressionNode) {
        this.setLocation(location);
        this.setClassReference(builder.getProject(), type);
        this.setExpressionNode(expressionNode);
    }

    @Override
    protected void processChildWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
        this.accumulateTextFragments(builder, text, info);
    }

    protected NodeBase createExpressionNodeFromFragments(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info, Object defaultValue) {
        ITypeDefinition type = builder.getBuiltinType(this.getName());
        ISourceFragment[] fragments = info.getSourceFragments();
        ISourceLocation location = info.getSourceLocation();
        if (location == null) {
            location = tag.getLocationOfChildUnits();
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        return builder.createExpressionNode(null, type, fragments, location, FLAGS, defaultValue, classNode);
    }

    protected NodeBase parseExpressionNodeFromFragments(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info, Object defaultValue) {
        ITypeDefinition type = builder.getBuiltinType(this.getName());
        ISourceFragment[] fragments = info.getSourceFragments();
        ISourceLocation location = info.getSourceLocation();
        if (location == null) {
            location = tag.getLocationOfChildUnits();
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        return builder.parseExpressionNode(type, fragments, location, FLAGS, defaultValue, classNode, true);
    }

    protected void checkExpressionType(MXMLTreeBuilder builder, IDefinition expectedType) {
        RoyaleProject project;
        ITypeDefinition exprType;
        IExpressionNode expressionNode = (IExpressionNode)this.getExpressionNode();
        if (expressionNode != null && (exprType = expressionNode.resolveType(project = builder.getProject())) != null && !SemanticUtils.isValidTypeConversion(expectedType, exprType, project, builder.getCompilationUnit().isInvisible())) {
            ImplicitCoercionToUnrelatedTypeProblem problem = new ImplicitCoercionToUnrelatedTypeProblem(expressionNode, exprType.getQualifiedName(), expectedType.getQualifiedName());
            builder.addProblem(problem);
        }
    }

    protected static enum ExpressionType {
        BOOLEAN,
        INT,
        UINT,
        NUMBER,
        STRING,
        CLASS,
        FUNCTION,
        REGEXP;

    }
}

