/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleMetadataMap;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class GatherModuleMetadata
implements HotSwapCompilerPass {
    static final DiagnosticType MIXED_MODULE_TYPE = DiagnosticType.error("JSC_MIXED_MODULE_TYPE", "A file cannot be both {0} and {1}.");
    static final DiagnosticType INVALID_DECLARE_MODULE_ID_CALL = DiagnosticType.error("JSC_INVALID_DECLARE_NAMESPACE_CALL", "goog.declareModuleId parameter must be a string literal.");
    static final DiagnosticType DECLARE_MODULE_ID_OUTSIDE_ES6_MODULE = DiagnosticType.error("JSC_DECLARE_MODULE_NAMESPACE_OUTSIDE_ES6_MODULE", "goog.declareModuleId can only be called within ES6 modules.");
    static final DiagnosticType MULTIPLE_DECLARE_MODULE_NAMESPACE = DiagnosticType.error("JSC_MULTIPLE_DECLARE_MODULE_NAMESPACE", "goog.declareModuleId can only be called once per ES6 module.");
    static final DiagnosticType INVALID_REQUIRE_TYPE = DiagnosticType.error("JSC_INVALID_REQUIRE_TYPE", "Argument to goog.requireType must be a string.");
    static final DiagnosticType INVALID_SET_TEST_ONLY = DiagnosticType.error("JSC_INVALID_SET_TEST_ONLY", "Optional, single argument to goog.setTestOnly must be a string.");
    private static final Node GOOG_PROVIDE = IR.getprop(IR.name("goog"), IR.string("provide"));
    private static final Node GOOG_MODULE = IR.getprop(IR.name("goog"), IR.string("module"));
    private static final Node GOOG_REQUIRE = IR.getprop(IR.name("goog"), IR.string("require"));
    private static final Node GOOG_REQUIRE_TYPE = IR.getprop(IR.name("goog"), IR.string("requireType"));
    private static final Node GOOG_SET_TEST_ONLY = IR.getprop(IR.name("goog"), IR.string("setTestOnly"));
    private static final Node GOOG_MODULE_DECLARELEGACYNAMESPACE = IR.getprop(GOOG_MODULE.cloneTree(), IR.string("declareLegacyNamespace"));
    private static final Node GOOG_DECLARE_MODULE_ID = IR.getprop(IR.name("goog"), IR.string("declareModuleId"));
    private static final Node GOOG_MODULE_DECLARNAMESPACE = IR.getprop(GOOG_MODULE.cloneTree(), IR.string("declareNamespace"));
    private final Map<String, ModuleMetadataMap.ModuleMetadata> modulesByPath = new HashMap<String, ModuleMetadataMap.ModuleMetadata>();
    private final Map<String, ModuleMetadataMap.ModuleMetadata> modulesByGoogNamespace = new HashMap<String, ModuleMetadataMap.ModuleMetadata>();
    private ModuleMetadataBuilder currentModule;
    private ModuleMetadataBuilder parentModule;
    private Node loadModuleCall;
    private final AbstractCompiler compiler;
    private final boolean processCommonJsModules;
    private final ModuleLoader.ResolutionMode moduleResolutionMode;

    public GatherModuleMetadata(AbstractCompiler compiler, boolean processCommonJsModules, ModuleLoader.ResolutionMode moduleResolutionMode) {
        this.compiler = compiler;
        this.processCommonJsModules = processCommonJsModules;
        this.moduleResolutionMode = moduleResolutionMode;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, new Finder());
        NodeTraversal.traverse(this.compiler, root, new Finder());
        this.compiler.setModuleMetadataMap(new ModuleMetadataMap(this.modulesByPath, this.modulesByGoogNamespace));
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.modulesByPath.putAll(this.compiler.getModuleMetadataMap().getModulesByPath());
        this.modulesByGoogNamespace.putAll(this.compiler.getModuleMetadataMap().getModulesByGoogNamespace());
        ModuleMetadataMap.ModuleMetadata oldMetadata = this.modulesByPath.remove(this.compiler.getInput(originalRoot.getInputId()).getPath().toString());
        if (oldMetadata != null) {
            this.modulesByGoogNamespace.keySet().removeAll(oldMetadata.googNamespaces());
            for (ModuleMetadataMap.ModuleMetadata nestedMetadata : oldMetadata.nestedModules()) {
                this.modulesByGoogNamespace.keySet().removeAll(nestedMetadata.googNamespaces());
            }
        }
        NodeTraversal.traverse(this.compiler, scriptRoot, new Finder());
        this.compiler.setModuleMetadataMap(new ModuleMetadataMap(this.modulesByPath, this.modulesByGoogNamespace));
    }

    private final class Finder
    implements NodeTraversal.Callback {
        private Finder() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    this.enterModule(n, t.getInput().getPath());
                    break;
                }
                case IMPORT: 
                case EXPORT: {
                    this.visitImportOrExport(t, n);
                    break;
                }
                case CALL: {
                    if (!n.isCall() || !n.getFirstChild().matchesQualifiedName("goog.loadModule")) break;
                    GatherModuleMetadata.this.loadModuleCall = n;
                    this.enterModule(n, null);
                    break;
                }
            }
            return true;
        }

        private void visitImportOrExport(NodeTraversal t, Node importOrExport) {
            Preconditions.checkNotNull(GatherModuleMetadata.this.currentModule);
            GatherModuleMetadata.this.currentModule.moduleType(ModuleMetadataMap.ModuleType.ES6_MODULE, t, importOrExport);
            if (importOrExport.isImport() || importOrExport.hasTwoChildren() && importOrExport.getLastChild().isString()) {
                ((GatherModuleMetadata)GatherModuleMetadata.this).currentModule.metadataBuilder.es6ImportSpecifiersBuilder().add((Object)importOrExport.getLastChild().getString());
            }
        }

        private void enterModule(Node n, @Nullable ModuleLoader.ModulePath path) {
            ModuleMetadataBuilder newModule = new ModuleMetadataBuilder(n, path);
            if (GatherModuleMetadata.this.currentModule != null) {
                Preconditions.checkState(GatherModuleMetadata.this.parentModule == null, "Expected modules to be nested at most 2 deep.");
                GatherModuleMetadata.this.parentModule = GatherModuleMetadata.this.currentModule;
            }
            GatherModuleMetadata.this.currentModule = newModule;
        }

        private void leaveModule() {
            Preconditions.checkNotNull(GatherModuleMetadata.this.currentModule);
            ModuleMetadataMap.ModuleMetadata module = GatherModuleMetadata.this.currentModule.build();
            if (module.path() != null) {
                GatherModuleMetadata.this.modulesByPath.put(module.path().toString(), module);
            }
            for (String namespace : module.googNamespaces()) {
                GatherModuleMetadata.this.modulesByGoogNamespace.put(namespace, module);
            }
            if (GatherModuleMetadata.this.parentModule != null) {
                ((GatherModuleMetadata)GatherModuleMetadata.this).parentModule.metadataBuilder.nestedModulesBuilder().add((Object)module);
            }
            GatherModuleMetadata.this.currentModule = GatherModuleMetadata.this.parentModule;
            GatherModuleMetadata.this.parentModule = null;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (GatherModuleMetadata.this.processCommonJsModules && GatherModuleMetadata.this.currentModule != null && GatherModuleMetadata.this.currentModule.isScript() && (ProcessCommonJSModules.isCommonJsExport(t, n, GatherModuleMetadata.this.moduleResolutionMode) || ProcessCommonJSModules.isCommonJsImport(n, GatherModuleMetadata.this.moduleResolutionMode))) {
                GatherModuleMetadata.this.currentModule.moduleType(ModuleMetadataMap.ModuleType.COMMON_JS, t, n);
                return;
            }
            switch (n.getToken()) {
                case SCRIPT: {
                    this.leaveModule();
                    break;
                }
                case NAME: {
                    this.visitName(t, n);
                    break;
                }
                case CALL: {
                    if (GatherModuleMetadata.this.loadModuleCall == n) {
                        this.leaveModule();
                        GatherModuleMetadata.this.loadModuleCall = null;
                        break;
                    }
                    this.visitGoogCall(t, n);
                    break;
                }
            }
        }

        private boolean isFromGoogImport(Var goog) {
            Node nameNode = goog.getNameNode();
            return nameNode != null && nameNode.isImportStar() && nameNode.getString().equals("goog") && nameNode.getParent().getFirstChild().isEmpty() && nameNode.getParent().getLastChild().getString().endsWith("/goog.js");
        }

        private void visitName(NodeTraversal t, Node n) {
            if (!"goog".equals(n.getString())) {
                return;
            }
            Var root = (Var)t.getScope().getVar("goog");
            if (root != null && !this.isFromGoogImport(root)) {
                return;
            }
            ((GatherModuleMetadata)GatherModuleMetadata.this).currentModule.metadataBuilder.usesClosure(true);
        }

        private void visitGoogCall(NodeTraversal t, Node n) {
            if (!(n.hasChildren() && n.getFirstChild().isGetProp() && n.getFirstChild().isQualifiedName())) {
                return;
            }
            Node getprop = n.getFirstChild();
            Node firstProp = n.getFirstChild();
            while (firstProp.isGetProp()) {
                firstProp = firstProp.getFirstChild();
            }
            if (!firstProp.isName() || !firstProp.getString().equals("goog")) {
                return;
            }
            Var root = (Var)t.getScope().getVar("goog");
            if (root != null && root.isLocal() && !((Scope)root.getScope()).isModuleScope()) {
                return;
            }
            if (root != null && ((Scope)root.getScope()).isModuleScope() && !this.isFromGoogImport(root)) {
                return;
            }
            if (root == null || NodeUtil.getEnclosingScript(root.getNameNode()) != NodeUtil.getEnclosingScript(n)) {
                ((GatherModuleMetadata)GatherModuleMetadata.this).currentModule.metadataBuilder.usesClosure(true);
            }
            if (getprop.matchesQualifiedName(GOOG_PROVIDE)) {
                GatherModuleMetadata.this.currentModule.moduleType(ModuleMetadataMap.ModuleType.GOOG_PROVIDE, t, n);
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    String namespace = n.getLastChild().getString();
                    this.addNamespace(GatherModuleMetadata.this.currentModule, namespace, t, n);
                } else {
                    t.report(n, ClosureRewriteModule.INVALID_PROVIDE_NAMESPACE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_MODULE)) {
                GatherModuleMetadata.this.currentModule.moduleType(ModuleMetadataMap.ModuleType.GOOG_MODULE, t, n);
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    String namespace = n.getLastChild().getString();
                    this.addNamespace(GatherModuleMetadata.this.currentModule, namespace, t, n);
                } else {
                    t.report(n, ClosureRewriteModule.INVALID_MODULE_NAMESPACE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                GatherModuleMetadata.this.currentModule.recordDeclareLegacyNamespace(n);
            } else if (getprop.matchesQualifiedName(GOOG_DECLARE_MODULE_ID) || getprop.matchesQualifiedName(GOOG_MODULE_DECLARNAMESPACE)) {
                if (GatherModuleMetadata.this.currentModule.declaredModuleId != null) {
                    t.report(n, MULTIPLE_DECLARE_MODULE_NAMESPACE, new String[0]);
                }
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    GatherModuleMetadata.this.currentModule.recordDeclareModuleId(n);
                    String namespace = n.getLastChild().getString();
                    this.addNamespace(GatherModuleMetadata.this.currentModule, namespace, t, n);
                } else {
                    t.report(n, INVALID_DECLARE_MODULE_ID_CALL, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_REQUIRE)) {
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    ((GatherModuleMetadata)GatherModuleMetadata.this).currentModule.metadataBuilder.requiredGoogNamespacesBuilder().add((Object)n.getLastChild().getString());
                } else {
                    t.report(n, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_REQUIRE_TYPE)) {
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    ((GatherModuleMetadata)GatherModuleMetadata.this).currentModule.metadataBuilder.requiredTypesBuilder().add((Object)n.getLastChild().getString());
                } else {
                    t.report(n, INVALID_REQUIRE_TYPE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_SET_TEST_ONLY)) {
                if (n.hasOneChild() || n.hasTwoChildren() && n.getLastChild().isString()) {
                    ((GatherModuleMetadata)GatherModuleMetadata.this).currentModule.metadataBuilder.isTestOnly(true);
                } else {
                    t.report(n, INVALID_SET_TEST_ONLY, new String[0]);
                }
            }
        }

        private void addNamespace(ModuleMetadataBuilder module, String namespace, NodeTraversal t, Node n) {
            ModuleMetadataMap.ModuleType existingType = null;
            if (module.googNamespaces.contains(namespace)) {
                existingType = module.metadataBuilder.moduleType();
            } else {
                ModuleMetadataMap.ModuleMetadata existingModule = (ModuleMetadataMap.ModuleMetadata)GatherModuleMetadata.this.modulesByGoogNamespace.get(namespace);
                if (existingModule != null) {
                    existingType = existingModule.moduleType();
                }
            }
            ((GatherModuleMetadata)GatherModuleMetadata.this).currentModule.googNamespaces.add(namespace);
            if (existingType != null) {
                switch (existingType) {
                    case ES6_MODULE: 
                    case GOOG_MODULE: 
                    case LEGACY_GOOG_MODULE: {
                        t.report(n, ClosureRewriteModule.DUPLICATE_MODULE, namespace);
                        return;
                    }
                    case GOOG_PROVIDE: {
                        t.report(n, ClosureRewriteModule.DUPLICATE_NAMESPACE, namespace);
                        return;
                    }
                }
                throw new IllegalStateException("Unexpected module type: " + (Object)((Object)existingType));
            }
        }
    }

    private class ModuleMetadataBuilder {
        private boolean ambiguous;
        private Node declaredModuleId;
        private Node declaresLegacyNamespace;
        private final Node rootNode;
        final ModuleMetadataMap.ModuleMetadata.Builder metadataBuilder;
        LinkedHashMultiset<String> googNamespaces = LinkedHashMultiset.create();

        ModuleMetadataBuilder(@Nullable Node rootNode, ModuleLoader.ModulePath path) {
            this.metadataBuilder = ModuleMetadataMap.ModuleMetadata.builder();
            this.rootNode = rootNode;
            this.metadataBuilder.path(path).moduleType(ModuleMetadataMap.ModuleType.SCRIPT).usesClosure(false).isTestOnly(false);
        }

        void moduleType(ModuleMetadataMap.ModuleType type, NodeTraversal t, Node n) {
            Preconditions.checkNotNull(type);
            if (this.metadataBuilder.moduleType() == type) {
                return;
            }
            if (this.metadataBuilder.moduleType() == ModuleMetadataMap.ModuleType.SCRIPT) {
                this.metadataBuilder.moduleType(type);
                return;
            }
            this.ambiguous = true;
            t.report(n, MIXED_MODULE_TYPE, this.metadataBuilder.moduleType().description, type.description);
        }

        void recordDeclareModuleId(Node declaredModuleId) {
            this.declaredModuleId = declaredModuleId;
        }

        void recordDeclareLegacyNamespace(Node declaresLegacyNamespace) {
            this.declaresLegacyNamespace = declaresLegacyNamespace;
        }

        boolean isScript() {
            return this.metadataBuilder.moduleType() == ModuleMetadataMap.ModuleType.SCRIPT;
        }

        ModuleMetadataMap.ModuleMetadata build() {
            this.metadataBuilder.googNamespacesBuilder().addAll(this.googNamespaces);
            if (!this.ambiguous) {
                if (this.declaredModuleId != null && this.metadataBuilder.moduleType() != ModuleMetadataMap.ModuleType.ES6_MODULE) {
                    GatherModuleMetadata.this.compiler.report(JSError.make(this.declaredModuleId, DECLARE_MODULE_ID_OUTSIDE_ES6_MODULE, new String[0]));
                }
                if (this.declaresLegacyNamespace != null) {
                    if (this.metadataBuilder.moduleType() == ModuleMetadataMap.ModuleType.GOOG_MODULE) {
                        this.metadataBuilder.moduleType(ModuleMetadataMap.ModuleType.LEGACY_GOOG_MODULE);
                    } else {
                        GatherModuleMetadata.this.compiler.report(JSError.make(this.declaresLegacyNamespace, ClosureCheckModule.DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE, new String[0]));
                    }
                }
            }
            return this.metadataBuilder.build();
        }
    }
}

