// Copyright 2017 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview The forward declarations in this file are here to faciliate
 * the removal of "deps.js" from the "base" rule.  These types are
 * included in various extern files.  These rules should be cleaned up
 * so that these declarations aren't necessary.
 * @suppress {extraRequire}
 */

goog.forwardDeclare('goog.Promise');
goog.forwardDeclare('goog.date.DateLike');
goog.forwardDeclare('goog.date.DateTime');
goog.forwardDeclare('goog.events.EventId');
goog.forwardDeclare('goog.events.Key');
goog.forwardDeclare('goog.events.KeyCodes');
goog.forwardDeclare('goog.i18n.TimeZone');
goog.forwardDeclare('goog.math.Range');
goog.forwardDeclare('goog.math.Size');
goog.forwardDeclare('goog.structs.Map');
