/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AliasStrings
implements CompilerPass,
NodeTraversal.Callback {
    private static final Logger logger = Logger.getLogger(AliasStrings.class.getName());
    private static final String STRING_ALIAS_PREFIX = "$$S_";
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private Matcher blacklist = null;
    private final Set<String> aliasableStrings;
    private final boolean outputStringUsage;
    private final SortedMap<String, StringInfo> stringInfoMap = new TreeMap<String, StringInfo>();
    private final Set<String> usedHashedAliases = new LinkedHashSet<String>();
    private final Map<JSModule, Node> moduleVarParentMap = new HashMap<JSModule, Node>();
    int unitTestHashReductionMask = -1;

    AliasStrings(AbstractCompiler compiler, JSModuleGraph moduleGraph, Set<String> strings, String blacklistRegex, boolean outputStringUsage) {
        this.compiler = compiler;
        this.moduleGraph = moduleGraph;
        this.aliasableStrings = strings;
        this.blacklist = blacklistRegex.length() != 0 ? Pattern.compile(blacklistRegex).matcher("") : null;
        this.outputStringUsage = outputStringUsage;
    }

    @Override
    public void process(Node externs, Node root) {
        logger.fine("Aliasing common strings");
        NodeTraversal.traverse(this.compiler, root, this);
        this.replaceStringsWithAliases();
        this.addAliasDeclarationNodes();
        if (this.outputStringUsage) {
            this.outputStringUsage();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        switch (n.getToken()) {
            case TEMPLATELIT: 
            case TAGGED_TEMPLATELIT: 
            case TEMPLATELIT_SUB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isString() && !parent.isGetProp() && !parent.isRegExp()) {
            String str = n.getString();
            if ("undefined".equals(str)) {
                return;
            }
            if (this.blacklist != null && this.blacklist.reset(str).find()) {
                return;
            }
            if (this.aliasableStrings == null || this.aliasableStrings.contains(str)) {
                Node varParent;
                StringOccurrence occurrence = new StringOccurrence(n, parent);
                StringInfo info = this.getOrCreateStringInfo(str);
                info.occurrences.add(occurrence);
                ++info.numOccurrences;
                JSModule module = t.getModule();
                if (info.numOccurrences != 1) {
                    if (module != null && info.moduleToContainDecl != null && module != info.moduleToContainDecl) {
                        module = this.moduleGraph.getDeepestCommonDependencyInclusive(module, info.moduleToContainDecl);
                    } else {
                        return;
                    }
                }
                if ((varParent = this.moduleVarParentMap.get(module)) == null) {
                    varParent = this.compiler.getNodeForCodeInsertion(module);
                    this.moduleVarParentMap.put(module, varParent);
                }
                info.moduleToContainDecl = module;
                info.parentForNewVarDecl = varParent;
                info.siblingToInsertVarDeclBefore = varParent.getFirstChild();
            }
        }
    }

    private StringInfo getOrCreateStringInfo(String string) {
        StringInfo info = (StringInfo)this.stringInfoMap.get(string);
        if (info == null) {
            info = new StringInfo(this.stringInfoMap.size());
            this.stringInfoMap.put(string, info);
        }
        return info;
    }

    private void replaceStringsWithAliases() {
        for (Map.Entry<String, StringInfo> entry : this.stringInfoMap.entrySet()) {
            StringInfo info;
            String literal = entry.getKey();
            if (!AliasStrings.shouldReplaceWithAlias(literal, info = entry.getValue())) continue;
            for (StringOccurrence occurrence : info.occurrences) {
                this.replaceStringWithAliasName(occurrence, info.getVariableName(literal), info);
            }
        }
    }

    private void addAliasDeclarationNodes() {
        for (Map.Entry<String, StringInfo> entry : this.stringInfoMap.entrySet()) {
            StringInfo info = entry.getValue();
            if (!info.isAliased) continue;
            String alias = info.getVariableName(entry.getKey());
            Node var = IR.var(IR.name(alias), IR.string(entry.getKey()));
            var.useSourceInfoFromForTree(info.parentForNewVarDecl);
            if (info.siblingToInsertVarDeclBefore == null) {
                info.parentForNewVarDecl.addChildToFront(var);
            } else {
                info.parentForNewVarDecl.addChildBefore(var, info.siblingToInsertVarDeclBefore);
            }
            this.compiler.reportChangeToEnclosingScope(var);
        }
    }

    private static boolean shouldReplaceWithAlias(String str, StringInfo info) {
        int sizeOfStrings;
        int sizeOfVariable = 3;
        int sizeOfLiteral = 2 + str.length();
        int sizeOfAliases = 6 + sizeOfVariable + sizeOfLiteral + info.numOccurrences * sizeOfVariable;
        return sizeOfAliases < (sizeOfStrings = info.numOccurrences * sizeOfLiteral);
    }

    private void replaceStringWithAliasName(StringOccurrence occurrence, String name, StringInfo info) {
        Node nameNode = IR.name(name);
        occurrence.parent.replaceChild(occurrence.node, nameNode);
        info.isAliased = true;
        this.compiler.reportChangeToEnclosingScope(nameNode);
    }

    private void outputStringUsage() {
        StringBuilder sb = new StringBuilder("Strings used more than once:\n");
        for (Map.Entry<String, StringInfo> stringInfoEntry : this.stringInfoMap.entrySet()) {
            StringInfo info = stringInfoEntry.getValue();
            if (info.numOccurrences <= 1) continue;
            sb.append(info.numOccurrences);
            sb.append(": ");
            sb.append(stringInfoEntry.getKey());
            sb.append('\n');
        }
        logger.fine(sb.toString());
    }

    private final class StringInfo {
        final int id;
        boolean isAliased;
        final List<StringOccurrence> occurrences;
        int numOccurrences;
        JSModule moduleToContainDecl;
        Node parentForNewVarDecl;
        Node siblingToInsertVarDeclBefore;
        String aliasName;

        StringInfo(int id) {
            this.id = id;
            this.occurrences = new ArrayList<StringOccurrence>();
            this.isAliased = false;
        }

        String getVariableName(String stringLiteral) {
            if (this.aliasName == null) {
                this.aliasName = this.encodeStringAsIdentifier(AliasStrings.STRING_ALIAS_PREFIX, stringLiteral);
            }
            return this.aliasName;
        }

        String encodeStringAsIdentifier(String prefix, String s) {
            int maxLimit = 20;
            int length = s.length();
            int limit = Math.min(length, 20);
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            boolean protectHex = false;
            for (int i = 0; i < limit; ++i) {
                char ch = s.charAt(i);
                if (protectHex) {
                    if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') {
                        sb.append('_');
                    }
                    protectHex = false;
                }
                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                    sb.append(ch);
                    continue;
                }
                sb.append('$');
                sb.append(Integer.toHexString(ch));
                protectHex = true;
            }
            if (length == limit) {
                return sb.toString();
            }
            int hash = s.hashCode() & AliasStrings.this.unitTestHashReductionMask;
            sb.append('_');
            sb.append(Integer.toHexString(hash));
            String encoded = sb.toString();
            if (!AliasStrings.this.usedHashedAliases.add(encoded)) {
                encoded = encoded + "_" + this.id;
            }
            return encoded;
        }
    }

    private static final class StringOccurrence {
        final Node node;
        final Node parent;

        StringOccurrence(Node node, Node parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

