/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MissingTypeRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.VariableID, (node, tokenQuery, problems) -> this.checkVariableNode((IVariableNode)node, tokenQuery, problems));
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkVariableNode(IVariableNode variableNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IExpressionNode typeNode = variableNode.getVariableTypeNode();
        if (this.isValidTypeNode(typeNode)) {
            return;
        }
        problems.add(new MissingVariableTypeLinterProblem(variableNode));
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        for (IParameterNode paramNode : functionNode.getParameterNodes()) {
            IExpressionNode typeNode;
            if (paramNode.isRest() || this.isValidTypeNode(typeNode = paramNode.getVariableTypeNode())) continue;
            problems.add(new MissingFunctionParameterTypeLinterProblem(paramNode));
        }
        if (functionNode.isConstructor()) {
            return;
        }
        IExpressionNode typeNode = functionNode.getReturnTypeNode();
        if (!this.isValidTypeNode(typeNode)) {
            problems.add(new MissingFunctionReturnTypeLinterProblem(functionNode));
        }
    }

    private boolean isValidTypeNode(IExpressionNode typeNode) {
        IdentifierNode identifierNode;
        if (typeNode == null) {
            return false;
        }
        return !(typeNode instanceof IdentifierNode) || !(identifierNode = (IdentifierNode)typeNode).isImplicit();
    }

    public static class MissingFunctionReturnTypeLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing function return type";

        public MissingFunctionReturnTypeLinterProblem(IFunctionNode node) {
            super((ISourceLocation)node);
        }
    }

    public static class MissingFunctionParameterTypeLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing type for function parameter '${paramName}'";
        public String paramName;

        public MissingFunctionParameterTypeLinterProblem(IParameterNode node) {
            super((ISourceLocation)node);
            this.paramName = node.getName();
        }
    }

    public static class MissingVariableTypeLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing type for variable '${varName}'";
        public String varName;

        public MissingVariableTypeLinterProblem(IVariableNode node) {
            super((ISourceLocation)node);
            this.varName = node.getName();
        }
    }
}

