/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.everit.json.schema.ValidationException;

public abstract class AbstractKafkaJsonSchemaSerializer<T>
extends AbstractKafkaSchemaSerDe {
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean latestCompatStrict;
    protected ObjectMapper objectMapper = Jackson.newObjectMapper();
    protected SpecificationVersion specVersion;
    protected boolean oneofForNullables;
    protected boolean failUnknownProperties;
    protected boolean validate;

    protected void configure(KafkaJsonSchemaSerializerConfig config) {
        this.configureClientProperties(config, new JsonSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        boolean prettyPrint = config.getBoolean("json.indent.output");
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
        boolean writeDatesAsIso8601 = config.getBoolean("json.write.dates.iso8601");
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, !writeDatesAsIso8601);
        this.specVersion = SpecificationVersion.get(config.getString("json.schema.spec.version"));
        this.oneofForNullables = config.getBoolean("json.oneof.for.nullables");
        String inclusion = config.getString("json.default.property.inclusion");
        if (inclusion != null) {
            this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.valueOf(inclusion));
        }
        this.failUnknownProperties = config.getBoolean("json.fail.unknown.properties");
        this.validate = config.getBoolean("json.fail.invalid.schema");
    }

    protected KafkaJsonSchemaSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaJsonSchemaSerializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    protected byte[] serializeImpl(String subject, T object, JsonSchema schema2) throws SerializationException, InvalidConfigurationException {
        return this.serializeImpl(subject, null, null, object, schema2);
    }

    protected byte[] serializeImpl(String subject, String topic, Headers headers, T object, JsonSchema schema2) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the serializer or use serializer constructor with SchemaRegistryClient.");
        }
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            if (this.autoRegisterSchema) {
                Optional<ParsedSchema> optSchema;
                restClientErrorMsg = "Error registering JSON schema: ";
                Schema s2 = this.registerWithResponse(subject, schema2, this.normalizeSchema);
                if (s2.getSchema() != null && (optSchema = this.schemaRegistry.parseSchema(s2)).isPresent()) {
                    schema2 = (JsonSchema)optSchema.get();
                    schema2 = schema2.copy(s2.getVersion());
                }
                id = s2.getId();
            } else if (this.useSchemaId >= 0) {
                restClientErrorMsg = "Error retrieving schema ID";
                schema2 = (JsonSchema)this.lookupSchemaBySubjectAndId(subject, this.useSchemaId, schema2, this.idCompatStrict);
                id = this.schemaRegistry.getId(subject, schema2);
            } else if (this.metadata != null) {
                restClientErrorMsg = "Error retrieving latest with metadata '" + this.metadata + "'";
                schema2 = (JsonSchema)this.getLatestWithMetadata(subject);
                id = this.schemaRegistry.getId(subject, schema2);
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version: ";
                schema2 = (JsonSchema)this.lookupLatestVersion(subject, schema2, this.latestCompatStrict);
                id = this.schemaRegistry.getId(subject, schema2);
            } else {
                restClientErrorMsg = "Error retrieving JSON schema: ";
                id = this.schemaRegistry.getId(subject, schema2, this.normalizeSchema);
            }
            object = this.executeRules(subject, topic, headers, RuleMode.WRITE, null, schema2, object);
            if (this.validate) {
                object = this.validateJson(object, schema2);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            out.write(this.objectMapper.writeValueAsBytes(object));
            byte[] bytes = out.toByteArray();
            out.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (InterruptedIOException e) {
            throw new TimeoutException("Error serializing JSON message", e);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing JSON message", e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaJsonSchemaSerializer.toKafkaException(e, restClientErrorMsg + schema2);
        }
        finally {
            this.postOp(object);
        }
    }

    protected T validateJson(T object, JsonSchema schema2) throws SerializationException {
        try {
            JsonNode jsonNode = object instanceof JsonNode ? (JsonNode)object : this.objectMapper.convertValue(object, JsonNode.class);
            jsonNode = schema2.validate(jsonNode);
            return (T)(object instanceof JsonNode ? object : this.objectMapper.convertValue((Object)jsonNode, object.getClass()));
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("JSON " + object + " does not match schema " + schema2.canonicalString(), e);
        }
        catch (ValidationException e) {
            throw new SerializationException("Validation error in JSON " + object + ", Error report:\n" + e.toJSON().toString(2), e);
        }
    }
}

