/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import io.confluent.kafka.schemaregistry.json.jackson.JSONArraySerializer;
import io.confluent.kafka.schemaregistry.json.jackson.JSONBaseSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONObjectSerializer
extends JSONBaseSerializer<JSONObject> {
    private static final long serialVersionUID = 1L;
    public static final JSONObjectSerializer instance = new JSONObjectSerializer();

    public JSONObjectSerializer() {
        super(JSONObject.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, JSONObject value) {
        return value == null || value.length() == 0;
    }

    @Override
    public void serialize(JSONObject value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeStartObject(value);
        this.serializeContents(value, g2, provider);
        g2.writeEndObject();
    }

    @Override
    public void serializeWithType(JSONObject value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g2.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_OBJECT));
        this.serializeContents(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JSONObject value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        Iterator<String> it = value.keys();
        while (it.hasNext()) {
            String key = it.next();
            Object ob = value.opt(key);
            if (ob == null || ob == JSONObject.NULL) {
                if (!provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) continue;
                g2.writeNullField(key);
                continue;
            }
            g2.writeFieldName(key);
            Class<?> cls = ob.getClass();
            if (cls == JSONObject.class) {
                this.serialize((JSONObject)ob, g2, provider);
                continue;
            }
            if (cls == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, g2, provider);
                continue;
            }
            if (cls == String.class) {
                g2.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                g2.writeNumber((Integer)ob);
                continue;
            }
            if (cls == Long.class) {
                g2.writeNumber((Long)ob);
                continue;
            }
            if (cls == Boolean.class) {
                g2.writeBoolean((Boolean)ob);
                continue;
            }
            if (cls == Double.class) {
                g2.writeNumber((Double)ob);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(cls)) {
                this.serialize((JSONObject)ob, g2, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, g2, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, g2);
        }
    }
}

