/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.json.JsonMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.util.TokenBuffer;

public class AvroSchemaUtils {
    private static final GenericData GENERIC_DATA_INSTANCE = new GenericData();
    private static final ReflectData REFLECT_DATA_INSTANCE = new ReflectData();
    private static final ReflectData REFLECT_DATA_ALLOW_NULL_INSTANCE = new ReflectData.AllowNull();
    private static final SpecificData SPECIFIC_DATA_INSTANCE = new SpecificData();
    private static final EncoderFactory encoderFactory;
    private static final DecoderFactory decoderFactory;
    private static final ObjectMapper jsonMapper;
    private static final ObjectMapper jsonMapperWithOrderedProps;
    private static int DEFAULT_CACHE_CAPACITY;
    private static final Map<String, Schema> primitiveSchemas;
    private static final Map<Schema, Schema> transformedSchemas;

    public static GenericData getGenericData() {
        return GENERIC_DATA_INSTANCE;
    }

    public static ReflectData getReflectData() {
        return REFLECT_DATA_INSTANCE;
    }

    public static ReflectData getReflectDataAllowNull() {
        return REFLECT_DATA_ALLOW_NULL_INSTANCE;
    }

    public static SpecificData getSpecificData() {
        return SPECIFIC_DATA_INSTANCE;
    }

    public static SpecificData getSpecificDataForSchema(Schema reader) {
        Class clazz;
        if (reader != null && (reader.getType() == Schema.Type.RECORD || reader.getType() == Schema.Type.UNION) && (clazz = AvroSchemaUtils.getSpecificData().getClass(reader)) != null) {
            return AvroSchemaUtils.getSpecificDataForClass(clazz);
        }
        return AvroSchemaUtils.getSpecificData();
    }

    public static <T> SpecificData getSpecificDataForClass(Class<T> c) {
        return SpecificRecordBase.class.isAssignableFrom(c) ? SpecificData.getForClass(c) : AvroSchemaUtils.getSpecificData();
    }

    public static void addLogicalTypeConversion(GenericData avroData) {
        avroData.addLogicalTypeConversion(new Conversions.DecimalConversion());
        avroData.addLogicalTypeConversion(new Conversions.UUIDConversion());
        avroData.addLogicalTypeConversion(new TimeConversions.DateConversion());
        avroData.addLogicalTypeConversion(new TimeConversions.TimeMillisConversion());
        avroData.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
        avroData.addLogicalTypeConversion(new TimeConversions.TimestampMillisConversion());
        avroData.addLogicalTypeConversion(new TimeConversions.TimestampMicrosConversion());
        avroData.addLogicalTypeConversion(new TimeConversions.LocalTimestampMillisConversion());
        avroData.addLogicalTypeConversion(new TimeConversions.LocalTimestampMicrosConversion());
    }

    private static Schema createPrimitiveSchema(String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return new AvroSchema(schemaString).rawSchema();
    }

    public static AvroSchema copyOf(AvroSchema schema2) {
        return schema2.copy();
    }

    public static Map<String, Schema> getPrimitiveSchemas() {
        return Collections.unmodifiableMap(primitiveSchemas);
    }

    public static Schema getSchema(Object object) {
        return AvroSchemaUtils.getSchema(object, false, false, false, true);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean reflectionAllowNull, boolean removeJavaProperties) {
        return AvroSchemaUtils.getSchema(object, useReflection, reflectionAllowNull, removeJavaProperties, true);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean reflectionAllowNull, boolean removeJavaProperties, boolean throwError) {
        return AvroSchemaUtils.getSchema(object, useReflection, reflectionAllowNull, false, removeJavaProperties, throwError);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean reflectionAllowNull, boolean useLogicalTypeConverters, boolean removeJavaProperties, boolean throwError) {
        if (object == null) {
            return primitiveSchemas.get("Null");
        }
        if (object instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (object instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (object instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (object instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (object instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (object instanceof CharSequence) {
            return primitiveSchemas.get("String");
        }
        if (object instanceof byte[] || object instanceof ByteBuffer) {
            return primitiveSchemas.get("Bytes");
        }
        if (useReflection) {
            ReflectData reflectData = reflectionAllowNull ? (useLogicalTypeConverters ? AvroSchemaUtils.getReflectDataAllowNull() : ReflectData.AllowNull.get()) : (useLogicalTypeConverters ? AvroSchemaUtils.getReflectData() : ReflectData.get());
            Schema schema2 = reflectData.getSchema(object.getClass());
            if (schema2 == null) {
                throw new SerializationException("Schema is null for object of class " + object.getClass().getCanonicalName());
            }
            return schema2;
        }
        if (object instanceof GenericContainer) {
            Schema schema3 = ((GenericContainer)object).getSchema();
            if (removeJavaProperties) {
                Schema s2 = schema3;
                schema3 = transformedSchemas.computeIfAbsent(s2, k -> AvroSchemaUtils.removeJavaProperties(s2));
            }
            return schema3;
        }
        if (object instanceof Map) {
            Map mapValue = (Map)object;
            if (mapValue.isEmpty()) {
                return Schema.createMap(primitiveSchemas.get("Null"));
            }
            Schema valueSchema = AvroSchemaUtils.getSchema(mapValue.values().iterator().next(), useReflection, reflectionAllowNull, removeJavaProperties, throwError);
            return Schema.createMap(valueSchema);
        }
        if (throwError) {
            throw new IllegalArgumentException("Unsupported Avro type '" + object.getClass().getSimpleName() + "'. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord");
        }
        ReflectData reflectData = reflectionAllowNull ? (useLogicalTypeConverters ? AvroSchemaUtils.getReflectDataAllowNull() : ReflectData.AllowNull.get()) : (useLogicalTypeConverters ? AvroSchemaUtils.getReflectData() : ReflectData.get());
        Schema schema4 = reflectData.getSchema(object.getClass());
        if (schema4 == null) {
            throw new SerializationException("Schema is null for object of class " + object.getClass().getCanonicalName());
        }
        return schema4;
    }

    private static Schema removeJavaProperties(Schema schema2) {
        try {
            JsonNode node = jsonMapper.readTree(schema2.toString());
            AvroSchemaUtils.removeProperty(node, "avro.java.string");
            AvroSchema avroSchema = new AvroSchema(node.toString());
            return avroSchema.rawSchema();
        }
        catch (IOException e) {
            throw new SerializationException("Could not parse schema: " + schema2.toString());
        }
    }

    private static void removeProperty(JsonNode node, String propertyName) {
        block3: {
            block2: {
                if (!node.isObject()) break block2;
                ObjectNode objectNode = (ObjectNode)node;
                objectNode.remove(propertyName);
                Iterator<JsonNode> elements = objectNode.elements();
                while (elements.hasNext()) {
                    AvroSchemaUtils.removeProperty(elements.next(), propertyName);
                }
                break block3;
            }
            if (!node.isArray()) break block3;
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator<JsonNode> elements = arrayNode.elements();
            while (elements.hasNext()) {
                AvroSchemaUtils.removeProperty(elements.next(), propertyName);
            }
        }
    }

    public static Object toObject(JsonNode value, AvroSchema schema2) throws IOException {
        return AvroSchemaUtils.toObject(value, schema2, new GenericDatumReader<Object>(schema2.rawSchema(), schema2.rawSchema(), AvroSchemaUtils.getGenericData()));
    }

    public static Object toObject(JsonNode value, AvroSchema schema2, DatumReader<Object> reader) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            Schema rawSchema = schema2.rawSchema();
            jsonMapper.writeValue(out, (Object)value);
            Object var7_8 = object = reader.read(null, decoderFactory.jsonDecoder(rawSchema, new ByteArrayInputStream(out.toByteArray())));
            return var7_8;
        }
    }

    public static Object toObject(String value, AvroSchema schema2) throws IOException {
        return AvroSchemaUtils.toObject(value, schema2, new GenericDatumReader<Object>(schema2.rawSchema(), schema2.rawSchema(), AvroSchemaUtils.getGenericData()));
    }

    public static Object toObject(String value, AvroSchema schema2, DatumReader<Object> reader) throws IOException {
        Schema rawSchema = schema2.rawSchema();
        Object object = reader.read(null, decoderFactory.jsonDecoder(rawSchema, value));
        return object;
    }

    public static byte[] toJson(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            AvroSchemaUtils.toJson(value, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void toJson(Object value, OutputStream out) throws IOException {
        Schema schema2 = AvroSchemaUtils.getSchema(value, false, false, false, false);
        JsonEncoder encoder = encoderFactory.jsonEncoder(schema2, out);
        DatumWriter<?> writer = AvroSchemaUtils.getDatumWriter(value, schema2, true);
        Object wrappedValue = value;
        if (value instanceof byte[]) {
            wrappedValue = ByteBuffer.wrap((byte[])value);
        }
        writer.write(wrappedValue, encoder);
        encoder.flush();
    }

    public static DatumWriter<?> getDatumWriter(Object value, Schema schema2, boolean avroUseLogicalTypeConverters) {
        if (value instanceof SpecificRecord) {
            return new SpecificDatumWriter(schema2, avroUseLogicalTypeConverters ? AvroSchemaUtils.getSpecificDataForSchema(schema2) : SpecificData.getForSchema(schema2));
        }
        if (value instanceof GenericRecord) {
            return new GenericDatumWriter(schema2, avroUseLogicalTypeConverters ? AvroSchemaUtils.getGenericData() : GenericData.get());
        }
        return new ReflectDatumWriter(schema2, avroUseLogicalTypeConverters ? AvroSchemaUtils.getReflectData() : ReflectData.get());
    }

    public static JsonNode findMatchingEntity(JsonNode node, SchemaEntity entity) {
        String recordName;
        String nameSpace;
        String[] identifiers = entity.getEntityPath().split("\\.");
        SchemaEntity.EntityType type = entity.getEntityType();
        String fieldName = null;
        if (SchemaEntity.EntityType.SR_RECORD == type) {
            nameSpace = String.join((CharSequence)".", Arrays.copyOfRange(identifiers, 0, identifiers.length - 1));
            recordName = identifiers[identifiers.length - 1];
        } else {
            nameSpace = String.join((CharSequence)".", Arrays.copyOfRange(identifiers, 0, identifiers.length - 2));
            recordName = identifiers[identifiers.length - 2];
            fieldName = identifiers[identifiers.length - 1];
        }
        LinkedList<JsonNodeWithNS> toVisit = new LinkedList<JsonNodeWithNS>();
        JsonNode currNameSpace = node.get("namespace");
        toVisit.add(new JsonNodeWithNS(node, currNameSpace == null ? null : currNameSpace.asText()));
        block10: while (toVisit.size() > 0) {
            String schemaType;
            JsonNodeWithNS curr = (JsonNodeWithNS)toVisit.removeFirst();
            JsonNode currNode = curr.jsonNode();
            if (!currNode.has("type")) {
                currNode.elements().forEachRemaining(e -> toVisit.add(new JsonNodeWithNS((JsonNode)e, curr.namespace())));
                continue;
            }
            switch (schemaType = currNode.get("type").asText()) {
                case "record": {
                    if ((nameSpace.isEmpty() || nameSpace.equals(curr.namespace())) && recordName.equals(currNode.get("name").asText())) {
                        if (SchemaEntity.EntityType.SR_RECORD == type) {
                            return currNode;
                        }
                        Iterator<JsonNode> fieldsIter = currNode.get("fields").elements();
                        while (fieldsIter.hasNext()) {
                            JsonNode currField = fieldsIter.next();
                            if (!fieldName.equals(currField.get("name").asText())) continue;
                            return currField;
                        }
                        continue block10;
                    }
                    currNode.get("fields").elements().forEachRemaining(e -> toVisit.add(new JsonNodeWithNS((JsonNode)e, curr.namespace())));
                    break;
                }
                case "array": {
                    toVisit.add(new JsonNodeWithNS(currNode.get("items"), curr.namespace()));
                    break;
                }
                case "map": {
                    toVisit.add(new JsonNodeWithNS(currNode.get("values"), curr.namespace()));
                    break;
                }
                default: {
                    toVisit.add(new JsonNodeWithNS(currNode.get("type"), curr.namespace()));
                }
            }
        }
        throw new IllegalArgumentException(String.format("No matching path '%s' found in the schema", entity.getEntityPath()));
    }

    protected static String toNormalizedString(AvroSchema schema2) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            Schema.Parser parser = schema2.getParser();
            for (String resolvedRef : schema2.resolvedReferences().values()) {
                Schema schemaRef = parser.parse(resolvedRef);
                String fullName = schemaRef.getFullName();
                env.put(fullName, "\"" + fullName + "\"");
            }
            return AvroSchemaUtils.build(env, schema2.rawSchema(), new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Appendable build(Map<String, String> env, Schema s2, Appendable o) throws IOException {
        boolean firstTime = true;
        Schema.Type st = s2.getType();
        LogicalType lt = s2.getLogicalType();
        switch (st) {
            case UNION: {
                o.append('[');
                for (Schema b : s2.getTypes()) {
                    if (!firstTime) {
                        o.append(',');
                    } else {
                        firstTime = false;
                    }
                    AvroSchemaUtils.build(env, b, o);
                }
                return o.append(']');
            }
            case ARRAY: 
            case MAP: {
                o.append("{\"type\":\"").append(st.getName()).append("\"");
                if (st == Schema.Type.ARRAY) {
                    AvroSchemaUtils.build(env, s2.getElementType(), o.append(",\"items\":"));
                } else {
                    AvroSchemaUtils.build(env, s2.getValueType(), o.append(",\"values\":"));
                }
                AvroSchemaUtils.setSimpleProps(o, s2.getObjectProps());
                return o.append("}");
            }
            case ENUM: 
            case FIXED: 
            case RECORD: {
                String name = s2.getFullName();
                if (env.get(name) != null) {
                    return o.append(env.get(name));
                }
                String qname = "\"" + name + "\"";
                env.put(name, qname);
                o.append("{\"name\":").append(qname);
                o.append(",\"type\":\"").append(st.getName()).append("\"");
                if (st == Schema.Type.ENUM) {
                    o.append(",\"symbols\":[");
                    for (String enumSymbol : s2.getEnumSymbols()) {
                        if (!firstTime) {
                            o.append(',');
                        } else {
                            firstTime = false;
                        }
                        o.append('\"').append(enumSymbol).append('\"');
                    }
                    o.append("]");
                } else if (st == Schema.Type.FIXED) {
                    o.append(",\"size\":").append(Integer.toString(s2.getFixedSize()));
                    lt = s2.getLogicalType();
                    if (lt != null) {
                        AvroSchemaUtils.setLogicalProps(o, lt);
                    }
                } else {
                    o.append(",\"fields\":[");
                    for (Schema.Field f : s2.getFields()) {
                        if (!firstTime) {
                            o.append(',');
                        } else {
                            firstTime = false;
                        }
                        o.append("{\"name\":\"").append(f.name()).append("\"");
                        AvroSchemaUtils.build(env, f.schema(), o.append(",\"type\":"));
                        AvroSchemaUtils.setFieldProps(o, f);
                        o.append("}");
                    }
                    o.append("]");
                }
                AvroSchemaUtils.setComplexProps(o, s2);
                AvroSchemaUtils.setSimpleProps(o, s2.getObjectProps());
                return o.append("}");
            }
        }
        if (lt != null) {
            return AvroSchemaUtils.writeLogicalType(s2, lt, o);
        }
        if (s2.hasProps()) {
            o.append("{\"type\":\"").append(st.getName()).append('\"');
            AvroSchemaUtils.setSimpleProps(o, s2.getObjectProps());
            o.append("}");
        } else {
            o.append('\"').append(st.getName()).append('\"');
        }
        return o;
    }

    private static Appendable writeLogicalType(Schema s2, LogicalType lt, Appendable o) throws IOException {
        o.append("{\"type\":\"").append(s2.getType().getName()).append("\"");
        AvroSchemaUtils.setLogicalProps(o, lt);
        AvroSchemaUtils.setSimpleProps(o, s2.getObjectProps());
        return o.append("}");
    }

    private static void setLogicalProps(Appendable o, LogicalType lt) throws IOException {
        o.append(",\"").append("logicalType").append("\":\"").append(lt.getName()).append("\"");
        if (lt.getName().equals("decimal")) {
            LogicalTypes.Decimal dlt = (LogicalTypes.Decimal)lt;
            o.append(",\"precision\":").append(Integer.toString(dlt.getPrecision()));
            if (dlt.getScale() != 0) {
                o.append(",\"scale\":").append(Integer.toString(dlt.getScale()));
            }
        }
    }

    private static void setSimpleProps(Appendable o, Map<String, Object> schemaProps) throws IOException {
        TreeMap<String, Object> sortedProps = new TreeMap<String, Object>(schemaProps);
        for (Map.Entry entry : sortedProps.entrySet()) {
            String propKey = (String)entry.getKey();
            String propValue = AvroSchemaUtils.toJsonNode(entry.getValue()).toString();
            o.append(",\"").append(propKey).append("\":").append(propValue);
        }
    }

    private static void setComplexProps(Appendable o, Schema s2) throws IOException {
        Set<String> aliases;
        if (s2.getDoc() != null && !s2.getDoc().isEmpty()) {
            o.append(",\"doc\":").append(AvroSchemaUtils.toJsonNode(s2.getDoc()).toString());
        }
        if (!(aliases = s2.getAliases()).isEmpty()) {
            o.append(",\"aliases\":").append(AvroSchemaUtils.toJsonNode(new TreeSet<String>(aliases)).toString());
        }
        if (s2.getType() == Schema.Type.ENUM && s2.getEnumDefault() != null) {
            o.append(",\"default\":").append(AvroSchemaUtils.toJsonNode(s2.getEnumDefault()).toString());
        }
    }

    private static void setFieldProps(Appendable o, Schema.Field f) throws IOException {
        Set<String> aliases;
        if (f.order() != null) {
            o.append(",\"order\":\"").append(f.order().toString()).append("\"");
        }
        if (f.doc() != null) {
            o.append(",\"doc\":").append(AvroSchemaUtils.toJsonNode(f.doc()).toString());
        }
        if (!(aliases = f.aliases()).isEmpty()) {
            o.append(",\"aliases\":").append(AvroSchemaUtils.toJsonNode(new TreeSet<String>(aliases)).toString());
        }
        if (f.defaultVal() != null) {
            o.append(",\"default\":").append(AvroSchemaUtils.toJsonNode(f.defaultVal()).toString());
        }
        AvroSchemaUtils.setSimpleProps(o, f.getObjectProps());
    }

    static JsonNode toJsonNode(Object datum) {
        if (datum == null) {
            return null;
        }
        try {
            TokenBuffer generator = new TokenBuffer(jsonMapperWithOrderedProps, false);
            AvroSchemaUtils.genJson(datum, generator);
            return (JsonNode)jsonMapperWithOrderedProps.readTree(generator.asParser());
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    static void genJson(Object datum, JsonGenerator generator) throws IOException {
        if (datum == JsonProperties.NULL_VALUE) {
            generator.writeNull();
        } else if (datum instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry : ((Map)datum).entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                AvroSchemaUtils.genJson(entry.getValue(), generator);
            }
            generator.writeEndObject();
        } else if (datum instanceof Collection) {
            generator.writeStartArray();
            for (Object element : (Collection)datum) {
                AvroSchemaUtils.genJson(element, generator);
            }
            generator.writeEndArray();
        } else if (datum instanceof byte[]) {
            generator.writeString(new String((byte[])datum, StandardCharsets.ISO_8859_1));
        } else if (datum instanceof CharSequence || datum instanceof Enum) {
            generator.writeString(datum.toString());
        } else if (datum instanceof Double) {
            generator.writeNumber((Double)datum);
        } else if (datum instanceof Float) {
            generator.writeNumber(((Float)datum).floatValue());
        } else if (datum instanceof Long) {
            generator.writeNumber((Long)datum);
        } else if (datum instanceof Integer) {
            generator.writeNumber((Integer)datum);
        } else if (datum instanceof Boolean) {
            generator.writeBoolean((Boolean)datum);
        } else if (datum instanceof BigInteger) {
            generator.writeNumber((BigInteger)datum);
        } else if (datum instanceof BigDecimal) {
            generator.writeNumber((BigDecimal)datum);
        } else {
            throw new AvroRuntimeException("Unknown datum class: " + datum.getClass());
        }
    }

    static {
        AvroSchemaUtils.addLogicalTypeConversion(GENERIC_DATA_INSTANCE);
        AvroSchemaUtils.addLogicalTypeConversion(REFLECT_DATA_INSTANCE);
        AvroSchemaUtils.addLogicalTypeConversion(REFLECT_DATA_ALLOW_NULL_INSTANCE);
        AvroSchemaUtils.addLogicalTypeConversion(SPECIFIC_DATA_INSTANCE);
        encoderFactory = EncoderFactory.get();
        decoderFactory = DecoderFactory.get();
        jsonMapper = JacksonMapper.INSTANCE;
        jsonMapperWithOrderedProps = ((JsonMapper.Builder)JsonMapper.builder().nodeFactory(new SortingNodeFactory(false))).build();
        DEFAULT_CACHE_CAPACITY = 1000;
        transformedSchemas = new BoundedConcurrentHashMap<Schema, Schema>(DEFAULT_CACHE_CAPACITY);
        primitiveSchemas = new HashMap<String, Schema>();
        primitiveSchemas.put("Null", AvroSchemaUtils.createPrimitiveSchema("null"));
        primitiveSchemas.put("Boolean", AvroSchemaUtils.createPrimitiveSchema("boolean"));
        primitiveSchemas.put("Integer", AvroSchemaUtils.createPrimitiveSchema("int"));
        primitiveSchemas.put("Long", AvroSchemaUtils.createPrimitiveSchema("long"));
        primitiveSchemas.put("Float", AvroSchemaUtils.createPrimitiveSchema("float"));
        primitiveSchemas.put("Double", AvroSchemaUtils.createPrimitiveSchema("double"));
        primitiveSchemas.put("String", AvroSchemaUtils.createPrimitiveSchema("string"));
        primitiveSchemas.put("Bytes", AvroSchemaUtils.createPrimitiveSchema("bytes"));
    }

    static class JsonNodeWithNS {
        private final JsonNode node;
        private final String namespace;

        public JsonNodeWithNS(JsonNode node, String parentNamespace) {
            this.node = node;
            JsonNode namespaceNode = node.get("namespace");
            this.namespace = namespaceNode == null ? parentNamespace : namespaceNode.asText();
        }

        public JsonNode jsonNode() {
            return this.node;
        }

        public String namespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonNodeWithNS other = (JsonNodeWithNS)o;
            return Objects.equals(this.namespace, other.namespace()) && Objects.equals(this.node, other.jsonNode());
        }

        public int hashCode() {
            int result = Objects.hashCode(this.node);
            result = 31 * result + Objects.hashCode(this.namespace);
            return result;
        }
    }

    static class SortingNodeFactory
    extends JsonNodeFactory {
        public SortingNodeFactory(boolean bigDecimalExact) {
            super(bigDecimalExact);
        }

        @Override
        public ObjectNode objectNode() {
            return new ObjectNode(this, new TreeMap<String, JsonNode>());
        }
    }
}

