/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.spark.common;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;

public abstract class BaseSparkSegmentMetadataPushJobRunner
implements IngestionJobRunner,
Serializable {
    protected SegmentGenerationJobSpec _spec;

    public BaseSparkSegmentMetadataPushJobRunner() {
    }

    public BaseSparkSegmentMetadataPushJobRunner(SegmentGenerationJobSpec spec) {
        this.init(spec);
    }

    public void init(SegmentGenerationJobSpec spec) {
        this._spec = spec;
    }

    public void run() {
        String[] files;
        URI outputDirURI;
        List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
        try {
            outputDirURI = new URI(this._spec.getOutputDirURI());
            if (outputDirURI.getScheme() == null) {
                outputDirURI = new File(this._spec.getOutputDirURI()).toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("outputDirURI is not valid - '" + this._spec.getOutputDirURI() + "'");
        }
        PinotFS outputDirFS = PinotFSFactory.create((String)outputDirURI.getScheme());
        try {
            files = outputDirFS.listFiles(outputDirURI, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list all files under outputDirURI - '" + String.valueOf(outputDirURI) + "'");
        }
        ArrayList<String> segmentsToPush = new ArrayList<String>();
        for (String file : files) {
            if (!file.endsWith(".tar.gz")) continue;
            segmentsToPush.add(file);
        }
        int pushParallelism = this._spec.getPushJobSpec().getPushParallelism();
        if (pushParallelism < 1) {
            pushParallelism = segmentsToPush.size();
        }
        if (pushParallelism == 1) {
            try {
                SegmentPushUtils.pushSegments((SegmentGenerationJobSpec)this._spec, (PinotFS)outputDirFS, segmentsToPush);
            }
            catch (AttemptsExceededException | RetriableOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.parallelizeMetadataPushJob(segmentsToPush, pinotFSSpecs, pushParallelism, outputDirURI);
        }
    }

    public abstract void parallelizeMetadataPushJob(List<String> var1, List<PinotFSSpec> var2, int var3, URI var4);
}

