/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.databind.util;

public enum NamingStrategyImpls {
    LOWER_CAMEL_CASE{

        @Override
        public String translate(String beanName) {
            return beanName;
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translate(String beanName) {
            char uc;
            if (beanName == null || beanName.isEmpty()) {
                return beanName;
            }
            char c = beanName.charAt(0);
            if (c == (uc = Character.toUpperCase(c))) {
                return beanName;
            }
            StringBuilder sb = new StringBuilder(beanName);
            sb.setCharAt(0, uc);
            return sb.toString();
        }
    }
    ,
    SNAKE_CASE{

        @Override
        public String translate(String beanName) {
            if (beanName == null) {
                return beanName;
            }
            int length = beanName.length();
            StringBuilder result2 = new StringBuilder(length * 2);
            int resultLength = 0;
            boolean wasPrevTranslated = false;
            for (int i = 0; i < length; ++i) {
                char c = beanName.charAt(i);
                if (i <= 0 && c == '_') continue;
                if (Character.isUpperCase(c)) {
                    if (!wasPrevTranslated && resultLength > 0 && result2.charAt(resultLength - 1) != '_') {
                        result2.append('_');
                        ++resultLength;
                    }
                    c = Character.toLowerCase(c);
                    wasPrevTranslated = true;
                } else {
                    wasPrevTranslated = false;
                }
                result2.append(c);
                ++resultLength;
            }
            return resultLength > 0 ? result2.toString() : beanName;
        }
    }
    ,
    UPPER_SNAKE_CASE{

        @Override
        public String translate(String beanName) {
            String output = SNAKE_CASE.translate(beanName);
            if (output == null) {
                return null;
            }
            return output.toUpperCase();
        }
    }
    ,
    LOWER_CASE{

        @Override
        public String translate(String beanName) {
            if (beanName == null || beanName.isEmpty()) {
                return beanName;
            }
            return beanName.toLowerCase();
        }
    }
    ,
    KEBAB_CASE{

        @Override
        public String translate(String beanName) {
            return 6.translateLowerCaseWithSeparator(beanName, '-');
        }
    }
    ,
    LOWER_DOT_CASE{

        @Override
        public String translate(String beanName) {
            return 7.translateLowerCaseWithSeparator(beanName, '.');
        }
    };


    public abstract String translate(String var1);

    static String translateLowerCaseWithSeparator(String beanName, char separator) {
        if (beanName == null || beanName.isEmpty()) {
            return beanName;
        }
        int length = beanName.length();
        StringBuilder result2 = new StringBuilder(length + (length >> 1));
        int upperCount = 0;
        for (int i = 0; i < length; ++i) {
            char ch = beanName.charAt(i);
            char lc = Character.toLowerCase(ch);
            if (lc == ch) {
                if (upperCount > 1) {
                    result2.insert(result2.length() - 1, separator);
                }
                upperCount = 0;
            } else {
                if (upperCount == 0 && i > 0) {
                    result2.append(separator);
                }
                ++upperCount;
            }
            result2.append(lc);
        }
        return result2.toString();
    }
}

