/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.pinot.plugin.stream.kafka.KafkaPartitionLevelStreamConfig;
import org.apache.pinot.plugin.stream.kafka.KafkaSSLUtils;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.spi.stream.StreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaPartitionLevelConnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPartitionLevelConnectionHandler.class);
    protected final KafkaPartitionLevelStreamConfig _config;
    protected final String _clientId;
    protected final int _partition;
    protected final String _topic;
    protected final Consumer<String, Bytes> _consumer;
    protected final TopicPartition _topicPartition;
    protected final Properties _consumerProp;

    public KafkaPartitionLevelConnectionHandler(String clientId, StreamConfig streamConfig, int partition) {
        this._config = new KafkaPartitionLevelStreamConfig(streamConfig);
        this._clientId = clientId;
        this._partition = partition;
        this._topic = this._config.getKafkaTopicName();
        this._consumerProp = this.buildProperties(streamConfig);
        KafkaSSLUtils.initSSL(this._consumerProp);
        this._consumer = this.createConsumer(this._consumerProp);
        this._topicPartition = new TopicPartition(this._topic, this._partition);
        this._consumer.assign(Collections.singletonList(this._topicPartition));
    }

    private Properties buildProperties(StreamConfig streamConfig) {
        Properties consumerProp = new Properties();
        consumerProp.putAll((Map<?, ?>)streamConfig.getStreamConfigsMap());
        consumerProp.put("bootstrap.servers", this._config.getBootstrapHosts());
        consumerProp.put("key.deserializer", StringDeserializer.class.getName());
        consumerProp.put("value.deserializer", BytesDeserializer.class.getName());
        if (this._config.getKafkaIsolationLevel() != null) {
            consumerProp.put("isolation.level", this._config.getKafkaIsolationLevel());
        }
        consumerProp.put("client.id", this._clientId);
        return consumerProp;
    }

    private Consumer<String, Bytes> createConsumer(Properties consumerProp) {
        return KafkaPartitionLevelConnectionHandler.retry(() -> new KafkaConsumer(consumerProp), 5);
    }

    protected AdminClient createAdminClient() {
        return KafkaPartitionLevelConnectionHandler.retry(() -> AdminClient.create(this._consumerProp), 5);
    }

    private static <T> T retry(Supplier<T> s, int nRetries) {
        int tries = 0;
        while (true) {
            try {
                return s.get();
            }
            catch (KafkaException e) {
                if (++tries >= nRetries) {
                    LOGGER.error("Caught exception while creating Kafka consumer, giving up", e);
                    throw e;
                }
                LOGGER.warn("Caught exception while creating Kafka consumer, retrying {}/{}", tries, nRetries, e);
                Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        this._consumer.close();
    }

    @VisibleForTesting
    protected KafkaPartitionLevelStreamConfig getKafkaPartitionLevelStreamConfig() {
        return this._config;
    }
}

