/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.spi.stream.BytesStreamMessage;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.MessageBatch;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;

public class KafkaMessageBatch
implements MessageBatch<byte[]> {
    private final List<BytesStreamMessage> _messages;
    private final int _unfilteredMessageCount;
    private final long _offsetOfNextBatch;
    private final long _firstOffset;
    private final StreamMessageMetadata _lastMessageMetadata;
    private final boolean _hasDataLoss;

    public KafkaMessageBatch(List<BytesStreamMessage> messages, int unfilteredMessageCount, long offsetOfNextBatch, long firstOffset, @Nullable StreamMessageMetadata lastMessageMetadata, boolean hasDataLoss) {
        this._messages = messages;
        this._unfilteredMessageCount = unfilteredMessageCount;
        this._offsetOfNextBatch = offsetOfNextBatch;
        this._firstOffset = firstOffset;
        this._lastMessageMetadata = lastMessageMetadata;
        this._hasDataLoss = hasDataLoss;
    }

    public int getMessageCount() {
        return this._messages.size();
    }

    public int getUnfilteredMessageCount() {
        return this._unfilteredMessageCount;
    }

    public BytesStreamMessage getStreamMessage(int index) {
        return this._messages.get(index);
    }

    public StreamPartitionMsgOffset getOffsetOfNextBatch() {
        return new LongMsgOffset(this._offsetOfNextBatch);
    }

    @Nullable
    public StreamPartitionMsgOffset getFirstMessageOffset() {
        return this._firstOffset >= 0L ? new LongMsgOffset(this._firstOffset) : null;
    }

    @Nullable
    public StreamMessageMetadata getLastMessageMetadata() {
        return this._lastMessageMetadata;
    }

    public boolean hasDataLoss() {
        return this._hasDataLoss;
    }
}

