/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class RegisterBrokerRecord
implements ApiMessage {
    int brokerId;
    Uuid incarnationId;
    long brokerEpoch;
    BrokerEndpointCollection endPoints;
    BrokerFeatureCollection features;
    String rack;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The broker id."), new Field("incarnation_id", Type.UUID, "The incarnation ID of the broker process"), new Field("broker_epoch", Type.INT64, "The broker epoch assigned by the controller."), new Field("end_points", new ArrayOf(BrokerEndpoint.SCHEMA_0), "The endpoints that can be used to communicate with this broker."), new Field("features", new ArrayOf(BrokerFeature.SCHEMA_0), "The features on this broker"), new Field("rack", Type.NULLABLE_STRING, "The broker rack."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RegisterBrokerRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RegisterBrokerRecord() {
        this.brokerId = 0;
        this.incarnationId = Uuid.ZERO_UUID;
        this.brokerEpoch = 0L;
        this.endPoints = new BrokerEndpointCollection(0);
        this.features = new BrokerFeatureCollection(0);
        this.rack = "";
    }

    @Override
    public short apiKey() {
        return 0;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        this.brokerId = _readable.readInt();
        this.incarnationId = _readable.readUuid();
        this.brokerEpoch = _readable.readLong();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field endPoints was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ImplicitLinkedHashMultiCollection newCollection = new BrokerEndpointCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerEndpoint(_readable, _version));
        }
        this.endPoints = newCollection;
        arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field features was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new BrokerFeatureCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerFeature(_readable, _version));
        }
        this.features = newCollection;
        short length = _readable.readShort();
        if (length < 0) {
            this.rack = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rack had invalid length " + length);
            }
            this.rack = _readable.readString(length);
        }
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeUuid(this.incarnationId);
        _writable.writeLong(this.brokerEpoch);
        _writable.writeInt(this.endPoints.size());
        for (BrokerEndpoint endPointsElement : this.endPoints) {
            endPointsElement.write(_writable, _cache, _version);
        }
        _writable.writeInt(this.features.size());
        for (BrokerFeature featuresElement : this.features) {
            featuresElement.write(_writable, _cache, _version);
        }
        if (this.rack == null) {
            _writable.writeShort((short)-1);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(this.rack);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(8);
        _size.addBytes(4);
        for (BrokerEndpoint endPointsElement : this.endPoints) {
            endPointsElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(4);
        for (BrokerFeature featuresElement : this.features) {
            featuresElement.addSize(_size, _cache, _version);
        }
        if (this.rack == null) {
            _size.addBytes(2);
        } else {
            byte[] _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'rack' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.rack, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterBrokerRecord)) {
            return false;
        }
        RegisterBrokerRecord other = (RegisterBrokerRecord)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (!this.incarnationId.equals(other.incarnationId)) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.endPoints == null ? other.endPoints != null : !this.endPoints.equals(other.endPoints)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + this.incarnationId.hashCode();
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.endPoints == null ? 0 : this.endPoints.hashCode());
        hashCode = 31 * hashCode + (this.features == null ? 0 : this.features.hashCode());
        hashCode = 31 * hashCode + (this.rack == null ? 0 : this.rack.hashCode());
        return hashCode;
    }

    @Override
    public RegisterBrokerRecord duplicate() {
        RegisterBrokerRecord _duplicate = new RegisterBrokerRecord();
        _duplicate.brokerId = this.brokerId;
        _duplicate.incarnationId = this.incarnationId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        BrokerEndpointCollection newEndPoints = new BrokerEndpointCollection(this.endPoints.size());
        for (BrokerEndpoint _element : this.endPoints) {
            newEndPoints.add(_element.duplicate());
        }
        _duplicate.endPoints = newEndPoints;
        BrokerFeatureCollection newFeatures = new BrokerFeatureCollection(this.features.size());
        for (BrokerFeature _element : this.features) {
            newFeatures.add(_element.duplicate());
        }
        _duplicate.features = newFeatures;
        _duplicate.rack = this.rack == null ? null : this.rack;
        return _duplicate;
    }

    public String toString() {
        return "RegisterBrokerRecord(brokerId=" + this.brokerId + ", incarnationId=" + this.incarnationId.toString() + ", brokerEpoch=" + this.brokerEpoch + ", endPoints=" + MessageUtil.deepToString(this.endPoints.iterator()) + ", features=" + MessageUtil.deepToString(this.features.iterator()) + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public BrokerEndpointCollection endPoints() {
        return this.endPoints;
    }

    public BrokerFeatureCollection features() {
        return this.features;
    }

    public String rack() {
        return this.rack;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RegisterBrokerRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public RegisterBrokerRecord setIncarnationId(Uuid v) {
        this.incarnationId = v;
        return this;
    }

    public RegisterBrokerRecord setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public RegisterBrokerRecord setEndPoints(BrokerEndpointCollection v) {
        this.endPoints = v;
        return this;
    }

    public RegisterBrokerRecord setFeatures(BrokerFeatureCollection v) {
        this.features = v;
        return this;
    }

    public RegisterBrokerRecord setRack(String v) {
        this.rack = v;
        return this;
    }

    public static class BrokerFeatureCollection
    extends ImplicitLinkedHashMultiCollection<BrokerFeature> {
        public BrokerFeatureCollection() {
        }

        public BrokerFeatureCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public BrokerFeatureCollection(Iterator<BrokerFeature> iterator) {
            super(iterator);
        }

        @Override
        public BrokerFeature find(String name) {
            BrokerFeature _key = new BrokerFeature();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<BrokerFeature> findAll(String name) {
            BrokerFeature _key = new BrokerFeature();
            _key.setName(name);
            return this.findAll(_key);
        }

        public BrokerFeatureCollection duplicate() {
            BrokerFeatureCollection _duplicate = new BrokerFeatureCollection(this.size());
            for (BrokerFeature _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class BrokerFeature
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short minSupportedVersion;
        short maxSupportedVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The feature name."), new Field("min_supported_version", Type.INT16, "The minimum supported feature level."), new Field("max_supported_version", Type.INT16, "The maximum supported feature level."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerFeature(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public BrokerFeature() {
            this.name = "";
            this.minSupportedVersion = 0;
            this.maxSupportedVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerFeature");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minSupportedVersion = _readable.readShort();
            this.maxSupportedVersion = _readable.readShort();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minSupportedVersion);
            _writable.writeShort(this.maxSupportedVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerFeature");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof BrokerFeature)) {
                return false;
            }
            BrokerFeature other = (BrokerFeature)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerFeature)) {
                return false;
            }
            BrokerFeature other = (BrokerFeature)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minSupportedVersion != other.minSupportedVersion) {
                return false;
            }
            if (this.maxSupportedVersion != other.maxSupportedVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public BrokerFeature duplicate() {
            BrokerFeature _duplicate = new BrokerFeature();
            _duplicate.name = this.name;
            _duplicate.minSupportedVersion = this.minSupportedVersion;
            _duplicate.maxSupportedVersion = this.maxSupportedVersion;
            return _duplicate;
        }

        public String toString() {
            return "BrokerFeature(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minSupportedVersion=" + this.minSupportedVersion + ", maxSupportedVersion=" + this.maxSupportedVersion + ")";
        }

        public String name() {
            return this.name;
        }

        public short minSupportedVersion() {
            return this.minSupportedVersion;
        }

        public short maxSupportedVersion() {
            return this.maxSupportedVersion;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerFeature setName(String v) {
            this.name = v;
            return this;
        }

        public BrokerFeature setMinSupportedVersion(short v) {
            this.minSupportedVersion = v;
            return this;
        }

        public BrokerFeature setMaxSupportedVersion(short v) {
            this.maxSupportedVersion = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class BrokerEndpointCollection
    extends ImplicitLinkedHashMultiCollection<BrokerEndpoint> {
        public BrokerEndpointCollection() {
        }

        public BrokerEndpointCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public BrokerEndpointCollection(Iterator<BrokerEndpoint> iterator) {
            super(iterator);
        }

        @Override
        public BrokerEndpoint find(String name) {
            BrokerEndpoint _key = new BrokerEndpoint();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<BrokerEndpoint> findAll(String name) {
            BrokerEndpoint _key = new BrokerEndpoint();
            _key.setName(name);
            return this.findAll(_key);
        }

        public BrokerEndpointCollection duplicate() {
            BrokerEndpointCollection _duplicate = new BrokerEndpointCollection(this.size());
            for (BrokerEndpoint _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class BrokerEndpoint
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        short securityProtocol;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The name of the endpoint."), new Field("host", Type.STRING, "The hostname."), new Field("port", Type.UINT16, "The port."), new Field("security_protocol", Type.INT16, "The security protocol."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerEndpoint(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public BrokerEndpoint() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.securityProtocol = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerEndpoint");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this.securityProtocol = _readable.readShort();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            _writable.writeShort(this.securityProtocol);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerEndpoint");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof BrokerEndpoint)) {
                return false;
            }
            BrokerEndpoint other = (BrokerEndpoint)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerEndpoint)) {
                return false;
            }
            BrokerEndpoint other = (BrokerEndpoint)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.securityProtocol != other.securityProtocol) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public BrokerEndpoint duplicate() {
            BrokerEndpoint _duplicate = new BrokerEndpoint();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.securityProtocol = this.securityProtocol;
            return _duplicate;
        }

        public String toString() {
            return "BrokerEndpoint(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", securityProtocol=" + this.securityProtocol + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerEndpoint setName(String v) {
            this.name = v;
            return this;
        }

        public BrokerEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public BrokerEndpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + "for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        public BrokerEndpoint setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

