/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$;
import kafka.network.RequestConvertToJson$;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$$eq$colon$eq$;
import scala.Some;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\n\u0014\u0001aA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u00151\b\u0001\"\u0003x\u0011\u0015I\b\u0001\"\u0003{\u0011\u0015a\b\u0001\"\u0003~\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!1!\r\u0001C\u0005\u0003\u000bAq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u0011\u0011\u0010\u0001\u0005\n\u0005%%A\u0006+fgR\u0014\u0016M\u001a;SKF,Xm\u001d;IC:$G.\u001a:\u000b\u0005Q)\u0012!\u0002;p_2\u001c(\"\u0001\f\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!G\u0010&!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001eI\u0007\u0002C)\u0011!%F\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0011\n#!E!qSJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB\u0011a%K\u0007\u0002O)\u0011\u0001&F\u0001\u0006kRLGn]\u0005\u0003U\u001d\u0012q\u0001T8hO&tw-A\u0006sC\u001a$X*\u00198bO\u0016\u0014\bGA\u00176!\rq\u0013gM\u0007\u0002_)\u0011\u0001'F\u0001\u0005e\u00064G/\u0003\u00023_\tY!+\u00194u\u001b\u0006t\u0017mZ3s!\t!T\u0007\u0004\u0001\u0005\u0013Y\n\u0011\u0011!A\u0001\u0006\u00039$aA0%cE\u0011\u0001h\u000f\t\u00035eJ!AO\u000e\u0003\u000f9{G\u000f[5oOB\u0011!\u0004P\u0005\u0003{m\u00111!\u00118z\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u000b\u0002\u000f9,Go^8sW&\u0011A)\u0011\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003\u0011!\u0018.\\3\u0011\u0005\u001d\u0003V\"\u0001%\u000b\u0005!J%B\u0001&L\u0003\u0019\u0019w.\\7p]*\u0011a\u0003\u0014\u0006\u0003\u001b:\u000ba!\u00199bG\",'\"A(\u0002\u0007=\u0014x-\u0003\u0002R\u0011\n!A+[7f\u0003E\t\u0007/\u001b,feNLwN\\'b]\u0006<WM\u001d\t\u0003AQK!!V\u0011\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u00061j{\u0006-\u0019\t\u00033\u0002i\u0011a\u0005\u0005\u0006W\u0015\u0001\ra\u0017\u0019\u00039z\u00032AL\u0019^!\t!d\fB\u000575\u0006\u0005\t\u0011!B\u0001o!)a(\u0002a\u0001\u007f!)Q)\u0002a\u0001\r\")!+\u0002a\u0001'\u00061\u0001.\u00198eY\u0016$\"\u0001Z4\u0011\u0005i)\u0017B\u00014\u001c\u0005\u0011)f.\u001b;\t\u000b!4\u0001\u0019A5\u0002\u000fI,\u0017/^3tiB\u0011!.\u001c\b\u0003\u0001.L!\u0001\\!\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011an\u001c\u0002\b%\u0016\fX/Z:u\u0015\ta\u0017)A\tiC:$G.Z!qSZ+'o]5p]N$\"\u0001\u001a:\t\u000b!<\u0001\u0019A5\u0002\u0015!\fg\u000e\u001a7f->$X\r\u0006\u0002ek\")\u0001\u000e\u0003a\u0001S\u00061\u0002.\u00198eY\u0016\u0014UmZ5o#V|'/^7Fa>\u001c\u0007\u000e\u0006\u0002eq\")\u0001.\u0003a\u0001S\u0006!\u0002.\u00198eY\u0016,e\u000eZ)v_J,X.\u00129pG\"$\"\u0001Z>\t\u000b!T\u0001\u0019A5\u0002\u0017!\fg\u000e\u001a7f\r\u0016$8\r\u001b\u000b\u0003IzDQ\u0001[\u0006A\u0002%\f1\u0003[1oI2,g)\u001a;dQNs\u0017\r]:i_R$2\u0001ZA\u0002\u0011\u0015AG\u00021\u0001j)\u0015!\u0017qAA\u0005\u0011\u0015AW\u00021\u0001j\u0011\u001d\tY!\u0004a\u0001\u0003\u001b\tQBY;jY\u0012\u0014Vm\u001d9p]N,\u0007c\u0002\u000e\u0002\u0010\u0005M\u0011qD\u0005\u0004\u0003#Y\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\u0013\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u001e\u0005]!AC!qS6+7o]1hKB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&%\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003S\t\u0019C\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\u0006Y\u0001.\u00198eY\u0016,%O]8s)\u0015!\u0017qFA\u0019\u0011\u0015Ag\u00021\u0001j\u0011\u001d\t\u0019D\u0004a\u0001\u0003k\t1!\u001a:s!\u0011\t9$a\u0012\u000f\t\u0005e\u00121\t\b\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH\f\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0012bAA#7\u00059\u0001/Y2lC\u001e,\u0017\u0002BA%\u0003\u0017\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u00153$A\bdY>\u001cXmQ8o]\u0016\u001cG/[8o)\u0015!\u0017\u0011KA*\u0011\u0015Aw\u00021\u0001j\u0011\u001d\t)f\u0004a\u0001\u0003/\n1\"\u001a:s_J\u001cu.\u001e8ugBA\u0011\u0011LA2\u0003O\ni'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0014\u0001\u00026bm\u0006LA!!\u001a\u0002\\\t\u0019Q*\u00199\u0011\t\u0005U\u0011\u0011N\u0005\u0005\u0003W\n9B\u0001\u0004FeJ|'o\u001d\t\u0005\u0003_\n)(\u0004\u0002\u0002r)!\u00111OA0\u0003\u0011a\u0017M\\4\n\t\u0005]\u0014\u0011\u000f\u0002\b\u0013:$XmZ3s\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u0015!\u0017QPA@\u0011\u0015A\u0007\u00031\u0001j\u0011\u001d\t\t\t\u0005a\u0001\u0003\u0007\u000b1B]3ta>t7/Z(qiB)!$!\"\u0002 %\u0019\u0011qQ\u000e\u0003\r=\u0003H/[8o)\r!\u00171\u0012\u0005\b\u0003\u001b\u000b\u0002\u0019AAH\u0003!\u0011Xm\u001d9p]N,\u0007c\u00016\u0002\u0012&\u0019\u00111S8\u0003\u0011I+7\u000f]8og\u0016\u0004")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request) {
        block13: {
            try {
                try {
                    this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Handling request:").append(request.requestDesc(true)).append(" from connection ").append(request$1.context().connectionId).append(";").append("securityProtocol:").append((Object)request$1.context().securityProtocol).append(",principal:").append(request$1.context().principal).toString());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (((Object)((Object)ApiKeys.API_VERSIONS)).equals((Object)apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.VOTE)).equals((Object)apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.BEGIN_QUORUM_EPOCH)).equals((Object)apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.END_QUORUM_EPOCH)).equals((Object)apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.FETCH)).equals((Object)apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.FETCH_SNAPSHOT)).equals((Object)apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported api key: ").append((Object)request.header().apiKey()).toString());
                }
                catch (FatalExitError fatalExitError) {
                    throw fatalExitError;
                }
                catch (Throwable e) {
                    this.handleError(request, e);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.sendResponse(request, new Some<AbstractResponse>(this.apiVersionManager.apiVersionResponse(0)));
    }

    private void handleVote(RequestChannel.Request request) {
        Function1<ApiMessage, VoteResponse> & Serializable & scala.Serializable handle_buildResponse = (Function1<ApiMessage, VoteResponse> & Serializable & scala.Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, new Some<AbstractResponse>(res));
        });
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        Function1<ApiMessage, BeginQuorumEpochResponse> & Serializable & scala.Serializable handle_buildResponse = (Function1<ApiMessage, BeginQuorumEpochResponse> & Serializable & scala.Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, new Some<AbstractResponse>(res));
        });
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        Function1<ApiMessage, EndQuorumEpochResponse> & Serializable & scala.Serializable handle_buildResponse = (Function1<ApiMessage, EndQuorumEpochResponse> & Serializable & scala.Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, new Some<AbstractResponse>(res));
        });
    }

    private void handleFetch(RequestChannel.Request request) {
        Function1<ApiMessage, FetchResponse> & Serializable & scala.Serializable handle_buildResponse = (Function1<ApiMessage, FetchResponse> & Serializable & scala.Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, new Some<AbstractResponse>(res));
        });
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        Function1<ApiMessage, FetchSnapshotResponse> & Serializable & scala.Serializable handle_buildResponse = (Function1<ApiMessage, FetchSnapshotResponse> & Serializable & scala.Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, new Some<AbstractResponse>(res));
        });
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, new Some<AbstractResponse>(res));
        });
    }

    private void handleError(RequestChannel.Request request, Throwable err) {
        this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Error when handling request: ").append("clientId=").append(request.header().clientId()).append(", ").append("correlationId=").append(request.header().correlationId()).append(", ").append("api=").append((Object)request.header().apiKey()).append(", ").append("version=").append(request.header().apiVersion()).append(", ").append("body=").append(request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()))).toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> err);
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        AbstractResponse response = ((AbstractRequest)requestBody).getErrorResponse(0, err);
        if (response == null) {
            this.closeConnection(request, ((AbstractRequest)requestBody).errorCounts(err));
            return;
        }
        this.sendResponse(request, new Some<AbstractResponse>(response));
    }

    private void closeConnection(RequestChannel.Request request, java.util.Map<Errors, Integer> errorCounts) {
        this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)CollectionConverters$.MODULE$.mapAsScalaMapConverter(errorCounts).asScala());
        this.requestChannel.sendResponse(new RequestChannel.CloseConnectionResponse(request));
    }

    private void sendResponse(RequestChannel.Request request, Option<AbstractResponse> responseOpt) {
        RequestChannel.Response response2;
        responseOpt.foreach((Function1<AbstractResponse, Object> & Serializable & scala.Serializable)response -> {
            this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala());
            return BoxedUnit.UNIT;
        });
        if (responseOpt instanceof Some) {
            AbstractResponse response3 = (AbstractResponse)((Some)responseOpt).value();
            Send responseSend = request.context().buildResponseSend(response3);
            Option responseString = RequestChannel$.MODULE$.isRequestLoggingEnabled() ? new Some<JsonNode>(RequestConvertToJson$.MODULE$.response(response3, request.context().apiVersion())) : None$.MODULE$;
            response2 = new RequestChannel.SendResponse(request, responseSend, responseString, None$.MODULE$);
        } else if (None$.MODULE$.equals(responseOpt)) {
            response2 = new RequestChannel.NoOpResponse(request);
        } else {
            throw new MatchError(responseOpt);
        }
        this.sendResponse(response2);
    }

    private void sendResponse(RequestChannel.Response response) {
        this.requestChannel.sendResponse(response);
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
    }
}

