/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class GetOffsetShell$ {
    public static GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        Map map;
        void var21_19;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo("", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> timeOpt = parser.accepts("time", "timestamp of the offsets before that. [Note: No offset is returned, if the timestamp greater than recently commited record timestamp is given.]").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(-1L), (Long[])((Object[])new Long[0]));
        parser.accepts("offsets", "DEPRECATED AND IGNORED: number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        parser.accepts("max-wait-ms", "DEPRECATED AND IGNORED: The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        String topic = options.valueOf(topicOpt);
        String partitionsString = options.valueOf(partitionOpt);
        GenTraversable partitionIdsRequested = partitionsString.isEmpty() ? Predef$.MODULE$.Set().empty() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])partitionsString.split(","))).map((Function1<String, Object> & Serializable & scala.Serializable)partitionString -> BoxesRunTime.boxToInteger(GetOffsetShell$.$anonfun$main$1(partitionsString, partitionString)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSet();
        long listOffsetsTimestamp = options.valueOf(timeOpt);
        Properties config = new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(config, (Deserializer<byte[]>)new ByteArrayDeserializer(), (Deserializer<byte[]>)new ByteArrayDeserializer());
        boolean bl = false;
        Some some = null;
        Option<Seq<PartitionInfo>> option = this.listPartitionInfos(consumer, topic, (Set<Object>)partitionIdsRequested);
        if (None$.MODULE$.equals(option)) {
            System.err.println(new StringBuilder(21).append("Topic ").append(topic).append(" does not exist").toString());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (((Seq)some.value()).isEmpty()) {
                if (partitionIdsRequested.isEmpty()) {
                    System.err.println(new StringBuilder(23).append("Topic ").append(topic).append(" has 0 partitions").toString());
                } else {
                    System.err.println(new StringBuilder(53).append("Topic ").append(topic).append(" does not have any of the requested partitions ").append(partitionIdsRequested.mkString(",")).toString());
                }
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
        if (!bl) {
            throw new MatchError(option);
        }
        Seq p2 = (Seq)some.value();
        if (partitionIdsRequested.nonEmpty()) {
            ((IterableLike)partitionIdsRequested.$minus$minus(var21_19.map((Function1<PartitionInfo, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.partition()), Seq$.MODULE$.canBuildFrom()))).foreach((JFunction1$mcVI$sp & scala.Serializable)partitionId -> System.err.println(new StringBuilder(32).append("Error: partition ").append(partitionId).append(" does not exist").toString()));
        }
        Seq topicPartitions = ((TraversableLike)var21_19.sortBy((Function1<PartitionInfo, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.partition()), Ordering$Int$.MODULE$)).flatMap((Function1<PartitionInfo, Iterable> & Serializable & scala.Serializable)p -> {
            if (p.leader() == null) {
                System.err.println(new StringBuilder(62).append("Error: partition ").append(p.partition()).append(" does not have a leader. Skip getting offsets").toString());
                return Option$.MODULE$.option2Iterable(None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable(new Some<TopicPartition>(new TopicPartition(p.topic(), p.partition())));
        }, Seq$.MODULE$.canBuildFrom());
        if (-2L == listOffsetsTimestamp) {
            map = CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets(CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
        } else if (-1L == listOffsetsTimestamp) {
            map = CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets(CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
        } else {
            java.util.Map<TopicPartition, Long> timestampsToSearch = CollectionConverters$.MODULE$.mapAsJavaMapConverter(((TraversableOnce)topicPartitions.map((Function1<TopicPartition, Tuple2> & Serializable & scala.Serializable)tp -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Predef$.MODULE$.long2Long(listOffsetsTimestamp)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            map = ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(timestampsToSearch)).asScala()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndTimestamp x = (OffsetAndTimestamp)x0$1._2();
                Tuple2<TopicPartition, Object> tuple2 = x == null ? new Tuple2<TopicPartition, Object>(k, null) : new Tuple2<TopicPartition, Long>(k, Predef$.MODULE$.long2Long(x.offset()));
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
        }
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])map.toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger(GetOffsetShell$.$anonfun$main$8(x0$2)), (Ordering)Ordering$Int$.MODULE$))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
            GetOffsetShell$.$anonfun$main$9(topic, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<PartitionInfo>> listPartitionInfos(KafkaConsumer<?, ?> consumer, String topic, Set<Object> partitionIds) {
        Buffer partitionInfos = ((TraversableOnce)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.listTopics()).asScala()).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(GetOffsetShell$.$anonfun$listPartitionInfos$1(topic, x0$1)))).values().flatMap((Function1<List, Buffer> & Serializable & scala.Serializable)x$3 -> CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala(), Iterable$.MODULE$.canBuildFrom())).toBuffer();
        if (partitionInfos.isEmpty()) {
            return None$.MODULE$;
        }
        if (partitionIds.isEmpty()) {
            return new Some<Seq<PartitionInfo>>(partitionInfos);
        }
        return new Some<Seq<PartitionInfo>>((Seq<PartitionInfo>)partitionInfos.filter((Function1<PartitionInfo, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(partitionIds.contains(BoxesRunTime.boxToInteger(p.partition())))));
    }

    public static final /* synthetic */ int $anonfun$main$1(String partitionsString$1, String partitionString) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(new StringBuilder(84).append("--partitions expects a comma separated list of numeric partition ids, but received: ").append(partitionsString$1).toString());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public static final /* synthetic */ int $anonfun$main$8(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError((Object)null);
        }
        int n = ((TopicPartition)x0$2._1()).partition();
        return n;
    }

    public static final /* synthetic */ void $anonfun$main$9(String topic$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition tp = (TopicPartition)x0$3._1();
            Long offset = (Long)x0$3._2();
            Predef$.MODULE$.println(new StringBuilder(2).append(topic$1).append(":").append(tp.partition()).append(":").append(Option$.MODULE$.apply(offset).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).toString());
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ boolean $anonfun$listPartitionInfos$1(String topic$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        String string = (String)x0$1._1();
        boolean bl = !(string != null ? !string.equals(topic$2) : topic$2 != null);
        return bl;
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

